/**
 * Tenorierend.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

/**
 * Das Interface schreibt Klassen vor, eine Methode String erzeugeTenor() zu
 * implementieren. Dadurch zeichnet es Klassen aus, die zur Tenorfindung gebaut
 * sind und so z.B. in eine GUI eingebaut werden können.
 * 
 * @author Peter Felix Schuster (SchusterP2)
 * @date 21.08.2014
 */
public interface Tenorierend {

	/**
	 * Die Methode erzeugeTenor dient dazu, einen Tenor zu erzeugen, der auch
	 * nur aus dem Kostentenor bestehen kann.
	 * 
	 * @return den Tenortext als String.
	 */
	abstract String erzeugeTenor();

	/**
	 * Die Methode soll eine Beschreibung für die Art des Tenor zurückgeben,
	 * damit andere Klassen etwa das Dokument danach benennen können.
	 * 
	 * @return eine Beschreibung als String, z.B.
	 *         "Tenor nach Baumbachscher Kostenformel"
	 */
	abstract String getTenorBeschreibung();

}