/*
 * Vorsorgend.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import java.util.List;

import javax.swing.Action;
import javax.swing.JComponent;

import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangVorsorgeBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.VorsorgendeBeschriftung;

/**
 * Interface für die gemeinsamen Methoden von {@link VorsorgendeBeschriftung}
 * und {@link LangVorsorgeBeschriftung}
 *
 * @author Peter Schuster (setrok)
 * @date 05.10.2019
 *
 * @param E die von {@link Beschriftung} abgeleitete Klasse, die das Interface
 *          implementiert, also {@link VorsorgendeBeschriftung} oder
 *          {@link LangVorsorgeBeschriftung}
 */
public interface Vorsorgend<E extends Beschriftung> {

	/**
	 * @return gibt {@link #alternativeTitles} als
	 *         {@link List}&lt;{@link String}&gt; zurück. Das ist eine vorsorgend
	 *         bereitgehaltene Liste anderer {@link Beschriftung#getTitle()s, die
	 *         die {@link JComponent} bzw {@link Action} in anderen Zuständen tragen
	 *         kann.
	 */
	public List<String> getAlternativeTitles();

	/**
	 * @param alternativeTitles d. {@link #alternativeTitles}, d. gesetzt werden
	 *                          soll als {@link List}&lt;{@link String}&gt;.
	 */
	public void setAlternativeTitles(List<String> alternativeTitles);

	/**
	 * @return gibt {@link #alternativeDescriptions} als
	 *         {@link List}&lt;{@link String}&gt; zurück. Das ist eine vorsorgend
	 *         bereitgehaltene Liste anderer Beschreibungen, die die {@link Action}
	 *         in anderen Zuständen tragen kann.
	 */
	public List<String> getAlternativeDescriptions();

	/**
	 * @param alternativeDescriptions d. {@link #getAlternativeDescriptions}, d.
	 *                                gesetzt werden soll als
	 *                                {@link List}&lt;{@link String}&gt;.
	 */
	public void setAlternativeDescriptions(List<String> alternativeDescriptions);

	/**
	 * @return gibt als {@link boolean} zurück, also ob die
	 *         {@link #getAlternativeTitles()} den {@link Beschriftung#getTitle()}
	 *         mit {@link String#format(String, Object...)} bilden sollen.
	 */
	public boolean isFormatted();
	
	/**
	 * @param formatted d. {@link #formatted}, d. gesetzt werden soll als
	 *                  {@link boolean}.
	 */
	public void setFormatted(boolean formatted);
}
/*
 * Die Methode setzt einen Title aus den vorhandenen {@link
 * #getAlternativeTitles()}. Danach muss applyTo() aufgerufen werden.
 * 
 * @param index der Index des neuen Titles
 * 
 * @param beschrifter
 * 
 * @return die {@link Beschriftung} mit dem neuen {@link
 * Beschriftung#getTitle()}
 */
// public E changeTo(int index, ComponentBeschrifter beschrifter);

/*
 * Die Methode setzt einen Title aus den vorhandenen {@link
 * #getAlternativeTitles()}, sofern er enthalten ist. Danach muss applyTo()
 * aufgerufen werden.
 * 
 * @param title den {@link Beschriftung#getTitle()}, der herausgesucht werden
 * soll
 * 
 * @param beschrifter
 * 
 * @return <code>true</code>, wenn er in {@link #getAlternativeTitles()}
 * gefunden wird
 */
// public boolean changeTo(String title, ComponentBeschrifter beschrifter);
//@XmlElementWrapper(name = "alternativeDescriptions")
//@XmlElements({ @XmlElement(name = "alternativeDescription", type = String.class) })
//@XmlElementWrapper(name = "alternativeTitles")
//@XmlElement(name = "alternativeTitle")