/**
 * WerteLesbar.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;

/**
 * Das Interface definiert Methoden, um alle Werte einer Registerkarte (oder
 * eines sonstigen Oberflächenelements) zuzuweisen, auszulesen oder
 * zurückzusetzen.
 *
 * @author Peter Schuster (setrok)
 * @date 22.06.2018
 *
 * @param <E> ein von {@link UnterContainerKlasse} abgeleiteter Typ
 */
public interface WerteLesbar<E extends UnterContainerKlasse> {

	/**
	 * Die Methode dient dazu, die Oberflächenelemente des Panels mit Werten zu
	 * füllen, wie bisher setzeXxxTabellen()
	 * 
	 * @param container
	 */
	void setzeWerte(E container);

	/**
	 * Die Methode dient dazu, alle Programmzustände in einen
	 * {@link VerfahrensDatenContainer} zu packen
	 * 
	 * @return eine {@link UnterContainerKlasse} von
	 *         {@link VerfahrensDatenContainer}
	 */
	E baueRueckgabewert();

	/**
	 * Die Methode leert alle Tabellen und sonstige Oberflächenelemente. Damit kann
	 * man dann die Registerkarte initialisieren oder auf den Anfangszustand
	 * zurücksetzen.
	 * 
	 */
	void leereWerte();
}