package eu.gronos.kostenrechner.logic;

/**
 * Die Attribute der Klasse sind Zaehler und Nenner des Bruchs
 * 
 */
public class Bruch extends Number implements Comparable<Bruch>, Cloneable {
	private static final long serialVersionUID = -1876588875035366152L;
	private long zaehler;
	private long nenner;

	/** Standard-Konstruktor mit Zaehler und Nenner */
	public Bruch(long zaehler, long nenner) {
		this.zaehler = zaehler;
		this.nenner = nenner;
	}

	/** Wird der Konstruktor ohne Parameter aufgerufen, wird der Bruch zu 0/1 */
	public Bruch() {
		this(0, 1);
	}

	/**
	 * Wird der Konstruktor nur mit einem Integer aufgerufen, wird ein
	 * Ganzzahl-Bruch durch Aufruf des Standard-Konstruktors gebildet.
	 */
	public Bruch(long x) {
		this(x, 1);
	}

	/**
	 * Wird der Konstruktor nur mit einem Integer aufgerufen, wird der zunaechst in
	 * "ganze" Tausendstel umgewandelt und dann gekuerzt.
	 */
	public Bruch(double d) {
		this(1, 1000);
		double v = d * 1000;
		this.zaehler = (long) v;
		this.kuerzen();
	}

	/**
	 * Die Methode erzeugt eine Prozent-Angabe
	 * 
	 * @return ein {@link Double}
	 */
	public Double toPercent() {
		return new Double(100.0 * doubleValue());
	}

	/**
	 * Die Methode kürzt den Bruch
	 * 
	 */
	public void kuerzen() {
		long m, ggT, r;// lokale Variablen
		m = zaehler;
		ggT = nenner;
		r = m % ggT;
		while (r > 0) {
			m = ggT;
			ggT = r;
			r = m % ggT;
		}
		zaehler /= ggT;
		nenner /= ggT;
	}

	public String toString() {
		return zaehler + "/" + nenner;
	}

	@Override
	public boolean equals(Object other) {
		if (!(other instanceof Bruch)) {
			return false;
		}
		final Bruch x = (Bruch) other;
		final Bruch a = this.clone();
		final Bruch b = x.clone();
		a.kuerzen();
		b.kuerzen();
		if ((a.zaehler == b.zaehler) && (a.nenner == b.nenner)) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public Bruch clone() {
		return new Bruch(this.zaehler, this.nenner);
	}

	@Override
	public int compareTo(Bruch other) {
		Double thisDouble = this.doubleValue();
		Double otherDouble = other.doubleValue();
		return thisDouble.compareTo(otherDouble);
	}

	/**
	 * @return the zaehler
	 */
	public long getZaehler() {
		return zaehler;
	}

	/**
	 * @param zaehler the zaehler to set
	 */
	public void setZaehler(long zaehler) {
		this.zaehler = zaehler;
	}

	/**
	 * @return the nenner
	 */
	public long getNenner() {
		return nenner;
	}

	/**
	 * @param nenner the nenner to set
	 */
	public void setNenner(long nenner) {
		if (nenner != 0) {
			this.nenner = nenner;
		} else {
			throw new IllegalArgumentException("Der Nenner darf nicht 0 sein!");
		}
	}

	/**
	 * Die Methode wandelt den Bruch in einen Dezimalbruch um
	 * 
	 * @return ein double
	 * 
	 * @see java.lang.Number#doubleValue()
	 */
	@Override
	public double doubleValue() {
		return (double) zaehler / (double) nenner;
	}

	@Override
	public int intValue() {
		return (int) (longValue());
	}

	@Override
	public long longValue() {
		return getZaehler() / getNenner();
	}

	@Override
	public float floatValue() {
		return (float) getZaehler() / (float) getNenner();
	}
}
