package eu.gronos.kostenrechner.logic.baumbach;

/**
 * In der Klasse lässt sich speichern, ob Klage bzw. Widerklage ganz
 * zugesprochen oder ganz abgewiesen wurden. Ansonsten muss ein "Im Übrigen wird
 * die (Wider-)Klage abgewiesen" an den Tenor gehÃ¤ngt werden. Die
 * Initialisierung geht davon aus, dass gar nicht verurteilt wurde, solange
 * keine Verurteilung festgestellt ist.
 * 
 * @author Peter Schuster (setrok)
 * @date 13 Dec 2018
 *
 */
public class BaumbachImUebrigen {
	/*
	 * * Die lokale Variable speichert, ob Klage (Zeile 0) bzw. Widerklage (Zeile 1)
	 * ganz zugesprochen (Spalte 0) oder ganz abgewiesen (Spalte 1) wurden.
	 * Ansonsten muss ein "Im Übrigen wird die (Wider-)Klage abgewiesen" an den
	 * Tenor gehängt werden. Die Initialisierung geht davon aus, dass gar nicht
	 * verurteilt wurde, solange keine Verurteilung festgestellt ist. *
	 */
	private boolean klageVollBegruendet;// = false;
	private boolean klageGanzUnbegruendet;// = true;
	private boolean widerklageVollBegruendet;// = false;
	private boolean widerklageGanzUnbegruendet;// = true;

	/**
	 * Der Konstruktor lässt speichern, ob Klage bzw. Widerklage ganz zugesprochen
	 * oder ganz abgewiesen wurden { { false, true}, { false, true } };
	 * 
	 * @param klageVollBegruendet        {@link #isKlageVollBegruendet()} Standard:
	 *                                   false;
	 * @param klageGanzUnbegruendet      {@link #isKlageGanzUnbegruendet()}
	 *                                   Standard: true;
	 * @param widerklageVollBegruendet   {@link #isWiderklageVollBegruendet()}
	 *                                   Standard: false;
	 * @param widerklageGanzUnbegruendet {@link #isWiderklageGanzUnbegruendet()}
	 *                                   Standard: true;
	 */
	public BaumbachImUebrigen(boolean klageVollBegruendet, boolean klageGanzUnbegruendet,
			boolean widerklageVollBegruendet, boolean widerklageGanzUnbegruendet) {
		super();
		this.klageVollBegruendet = klageVollBegruendet;
		this.klageGanzUnbegruendet = klageGanzUnbegruendet;
		this.widerklageVollBegruendet = widerklageVollBegruendet;
		this.widerklageGanzUnbegruendet = widerklageGanzUnbegruendet;
	}

	/**
	 * @return Zusatz für Voll- oder Teilabweisung der Klage
	 */
	public String toKlageAbweisungsString() {
		if (isKlageGanzUnbegruendet()) {
			// ganzZugesprochenOderAbgewiesen[0][1]
			return "Die Klage wird abgewiesen.\n";
		} else if (!isKlageVollBegruendet()) {
			// !ganzZugesprochenOderAbgewiesen[0][0]
			return "Im Übrigen wird die Klage abgewiesen.\n";
		}
		return "";
	}

	/**
	 * @return Zusatz für Voll- oder Teilabweisung der Widerklage
	 */
	public String toWiderklageAbweisungsString() {
		if (isWiderklageGanzUnbegruendet()) {
			// (ganzZugesprochenOderAbgewiesen[1][1])
			return "Die Widerklage wird abgewiesen.\n";
		} else if (!isWiderklageVollBegruendet()) {
			// (!ganzZugesprochenOderAbgewiesen[1][0])
			return "Im Übrigen wird die Widerklage abgewiesen.\n";
		}
		return "";
	}

	/**
	 * @return gibt als boolean zurück, ob die Klage vollumfänglich begründet ist.
	 */
	public boolean isKlageVollBegruendet() {
		return klageVollBegruendet;
	}

	/**
	 * war ganzZugesprochenOderAbgewiesen[0][0]
	 * 
	 * @param klageVollBegruendet d. {@link #isKlageVollBegruendet}, d. gesetzt
	 *                            werden soll als boolean
	 */
	public void setKlageVollBegruendet(boolean klageVollBegruendet) {
		this.klageVollBegruendet = klageVollBegruendet;
	}

	/**
	 * @return gibt als boolean zurück, ob die Klage gänzlich unbegründet ist
	 */
	public boolean isKlageGanzUnbegruendet() {
		return klageGanzUnbegruendet;
	}

	/**
	 * war ganzZugesprochenOderAbgewiesen[0][1]
	 * 
	 * @param klageGanzUnbegruendet d. {@link #isKlageGanzUnbegruendet}, d. gesetzt
	 *                              werden soll als boolean
	 */
	public void setKlageGanzUnbegruendet(boolean klageGanzUnbegruendet) {
		this.klageGanzUnbegruendet = klageGanzUnbegruendet;
	}

	/**
	 * @return gibt als boolean zurück, ob die Widerklage vollumfänglich begründet
	 *         ist.
	 */
	public boolean isWiderklageVollBegruendet() {
		return widerklageVollBegruendet;
	}

	/**
	 * war ganzZugesprochenOderAbgewiesen[1][0]
	 * 
	 * @param widerklageVollBegruendet d. {@link #isWiderklageVollBegruendet}, d.
	 *                                 gesetzt werden soll als boolean
	 */
	public void setWiderklageVollBegruendet(boolean widerklageVollBegruendet) {
		this.widerklageVollBegruendet = widerklageVollBegruendet;
	}

	/**
	 * @return gibt als boolean zurück, ob die Widerklage gänzlich unbegründet ist.
	 */
	public boolean isWiderklageGanzUnbegruendet() {
		return widerklageGanzUnbegruendet;
	}

	/**
	 * war ganzZugesprochenOderAbgewiesen[1][1]
	 * 
	 * @param widerklageGanzUnbegruendet d. {@link #isWiderklageGanzUnbegruendet},
	 *                                   d. gesetzt werden soll als boolean
	 */
	public void setWiderklageGanzUnbegruendet(boolean widerklageGanzUnbegruendet) {
		this.widerklageGanzUnbegruendet = widerklageGanzUnbegruendet;
	}
}
