/*
 * AngriffsTexter.java
 * eu.gronos.kostenrechner.logic.forderungen (Kostenrechner)
 */
package eu.gronos.kostenrechner.logic.forderungen;

import eu.gronos.kostenrechner.logic.TenorTexter;
import eu.gronos.kostenrechner.model.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.model.tenordaten.HauptsacheEntscheidungsElemente;
import eu.gronos.kostenrechner.model.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.model.tenordaten.StreitwertEntscheidungsElemente;

/**
 * Die Klasse verfasst die Tenortexte für
 * {@link AngriffsVerteidigungsmittelStaffelung}
 *
 * @author Peter Schuster (setrok)
 * @date 4 Jun 2019
 *
 */
public class AngriffsTexter extends TenorTexter<ForderungsStaffelung> {

	private double ganz;

	@Override
	public String texteHauptsache(HauptsacheEntscheidungsElemente hauptsache) {
		String tenor;
		final HauptsacheVerhaeltnis verhaeltnis = hauptsache.prozessverhaeltnisse.get(0);
		if (verhaeltnis.getVerurteilung() > 0) {
			tenor = satzBeginn(String.format(TenorTexter.VERURTEILUNGS_FORMAT,
					verhaeltnis.getSchuldner().parteiBezeichner(Beteiligter.NOMINATIV,
							verhaeltnis.getSchuldner().getLfdNr(), true),
					verhaeltnis.getGlaeubiger().parteiBezeichner(Beteiligter.DATIV,
							verhaeltnis.getGlaeubiger().getLfdNr(), true),
					(double) verhaeltnis.getVerurteilung()));
			if (ganz > verhaeltnis.getVerurteilung()) /* wenn nicht vollständig obsiegt oder verloren */
				tenor += TenorTexter.KLAGEABWEISUNG_IM_UEBRIGEN;
		} else
			tenor = TenorTexter.KLAGEABWEISUNG;
		tenor += "\n";
		return tenor;
	}

	@Override
	public String texteStreitwert(StreitwertEntscheidungsElemente elemente) {
		return String.format(TenorTexter.STREITWERT_FESTGESETZT_EINFACH, (double) elemente.streitwerte.get(0));
	}

	/**
	 * @param ganz d. {@link #ganz}, d. gesetzt werden soll als {@link double}.
	 */
	public void setGanz(double ganz) {
		this.ganz = ganz;
	}

}
