/**
 * GerichtsKostenBeteiligter.java
 * eu.gronos.kostenrechner.logic.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.baumbach;

import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.model.tenordaten.KostenTragungsVerhaeltnis;

/**
 * Ein {@link Beteiligter}, den {@link KostenTragungsVerhaeltnis} braucht, um
 * die Tragung von Gerichtskosten zu speichern
 *
 * @author Peter Schuster (setrok)
 * @date 11 Dec 2018
 *
 */
public class GerichtsKostenBeteiligter extends Beteiligter {
	private static final long serialVersionUID = -2204713166447254427L;

	public GerichtsKostenBeteiligter() {
		super();
		setTyp(Beteiligter.GERICHTSKOSTEN);
		setGenusNumerus(MAENNLICH);
		setLfdNr(1);
	}

	public GerichtsKostenBeteiligter(Beteiligter beteiligter) {
		this();
		setGenusNumerus(beteiligter.getGenusNumerus());
	}

	public GerichtsKostenBeteiligter(int typ, int genusNumerus) {
		this();
		setGenusNumerus(genusNumerus);
	}

}
