/*
 * ProtoBeteiligtenWerte.java
 * eu.gronos.kostenrechner.view.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.baumbach;

import java.util.Arrays;

import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenAssistentPruefer;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.view.baumbach.BaumbachAssistentDialog;

/**
 * Die Parameter-Klasse enthält die primitiven Werte (und Arrays von primitiven
 * Werten) des {@link BaumbachAssistentDialog}s und des
 * {@link StreitgenossenAssistentPruefer}s. Diese werden teilweise als
 * Startwerte gebraucht. Dann speichern sie die ausgelesenen Felder.
 *
 * @author Peter Schuster (setrok)
 * @date 13.09.2019
 *
 */
public class ProtoBeteiligtenWerte {
	/**
	 * klaegerZahl speichert die Zahl der Kläger auf Panel 1 als {@link int}.
	 */
	public int klaegerZahl = 1;
	/**
	 * klWk speichert als {@link boolean}, ob sich die Widerklage gegen den Kläger
	 * richtet.
	 */
	public boolean klWk = false;

	/**
	 * beklagtenZahl speichert die Anzahl der Beklagten als {@link int}.
	 */
	public int beklagtenZahl = 2;

	/**
	 * bkSwEinheitlich speichert als {@link boolean}, ob die Beklagten in derselben
	 * Höhe in Anspruch genommen werden.
	 */
	public boolean bkSwEinheitlich = true;
	/**
	 * bkStreitwert speichert entweder den einheitlichen Streitwert der Klage gegen
	 * die Beklagten oder den höchsten Einzelstreitwert der Klage als
	 * {@link double}.
	 */
	public double bkStreitwert = 0;
	/**
	 * bkGesamt speichert als {@link boolean}, ob die Beklagten gesamtschuldnerisch
	 * verurteilt werden.
	 */
	public boolean bkGesamt = true;
	/**
	 * bkGesamtIndices speichert
	 * {@link BaumbachGesamtschuldnerschaft#getAufzaehlung()} als {@link int[]}.
	 */
	public int[] bkGesamtIndices = new int[0];
	/**
	 * bkGesamtUnterliegen speichert das gesamtschuldnerische Unterliegen der
	 * Beklagten als {@link double}.
	 */
	public double bkGesamtUnterliegen = 0;
	public double bkUnterliegen = 0.0;
	/**
	 * bkWiderklaegerIndex speichert den index des Beklagten, der Widerkläger ist,
	 * als {@link int}.
	 */
	public int bkWiderklaegerIndex = -1;

	/**
	 * dwbkZahl speichert die Anzahl der Drittwiderbeklagten als {@link int}.
	 */
	public int dwbkZahl = 0;
	/**
	 * wbkZahl speichert die Anzahl der Widerbeklagten (also widerklagebeteiligter
	 * (!) Kläger und Drittwiderbeklagte)
	 */
	public int wbkZahl = 0;
	/**
	 * wkSwEinheitlich speichert als {@link boolean}, ob die Widerbeklagten in
	 * derselben Höhe in Anspruch genommen werden.
	 */
	public boolean wkSwEinheitlich = true;
	/**
	 * wkStreitwert speichert den einheitlichen bzw. den höchsten Streitwert der
	 * Widerklage als {@link double}.
	 */
	public double wkStreitwert = 0;
	/**
	 * wkGesamt speichert als {@link boolean}, ob die Widerbeklagten
	 * gesamtschuldnerisch verurteilt werden.
	 */
	public boolean wkGesamt = true;
	/**
	 * wkGesamtIndices speichert
	 * {@link BaumbachGesamtschuldnerschaft#getAufzaehlung()} als {@link int[]}.
	 */
	public int[] wkGesamtIndices = null;
	/**
	 * wkGesamtUnterliegen speichert das gesamtschuldnerische Unterliegen der
	 * Kl/Dwbk als {@link double}.
	 */
	public double wkGesamtUnterliegen = 0;
	/**
	 * wkUnterliegen speichert zuerst den Standardwert fürs Unterliegen, dann das
	 * höchste Unterliegen auf Widerbeklagtenseite als {@link double}.
	 */
	public double wkUnterliegen = 0;

	/**
	 * mitWiderklage speichert als {@link boolean}, ob auch die Schritte für die
	 * Widerklage durchgeführt werden sollen.
	 */
	public boolean mitWiderklage;
	/**
	 * ohneXjustiz speichert als {@link boolean}, ob ein
	 * {@link VerfahrensDatenContainer} mit Xjustiz-Daten übergeben worden ist.
	 */
	public boolean ohneXjustiz;

	/**
	 * tab2ueberspringen speichert als {@link boolean}, ob Tab 1 übersprungen wird,
	 * weil Xjustiz-Daten vorhanden sind.
	 */
	public boolean tab1ueberspringen = false;
	/**
	 * tab3ueberspringen speichert als {@link boolean}, ob Tab 2 übersprungen wird,
	 * weil Xjustiz-Daten vorhanden sind.
	 */
	public boolean tab2ueberspringen = false;
	/**
	 * tab4ueberspringen speichert als {@link boolean}, ob Tab 4 übersprungen wird,
	 * weil es weniger als zwei Beklagte gibt.
	 */
	public boolean tab4ueberspringen = false;
	/**
	 * tab6ueberspringen speichert als {@link boolean}, ob Tab 6 übersprungen wird,
	 * weil Xjustiz-Daten vorhanden sind.
	 */
	public boolean tab6ueberspringen = false;
	/**
	 * tab7ueberspringen speichert als {@link boolean}, ob Tab 7 übersprungen wird,
	 * weil Xjustiz-Daten vorhanden sind (oder es keine Drittwiderbeklagten gibt).
	 */
	public boolean tab7ueberspringen = false;
	/**
	 * tab9ueberspringen speichert als {@link boolean}, ob Tab 9 übersprungen wird,
	 * weil es weniger als zwei Widerbeklagte gibt.
	 */
	public boolean tab9ueberspringen = false;

	@Override
	public String toString() {
		return String.format(
				"ProtoBeteiligtenWerte [klaegerZahl=%s, klWk=%s, beklagtenZahl=%s, bkSwEinheitlich=%s, bkStreitwert=%s, bkGesamt=%s, bkGesamtIndices=%s, bkGesamtUnterliegen=%s, bkUnterliegen=%s, bkWiderklaegerIndex=%s, dwbkZahl=%s, wkSwEinheitlich=%s, wkStreitwert=%s, wkGesamt=%s, wkGesamtIndices=%s, wkGesamtUnterliegen=%s, wkUnterliegen=%s, mitWiderklage=%s, ohneXjustiz=%s, tab1ueberspringen=%s, tab2ueberspringen=%s, tab6ueberspringen=%s, tab7ueberspringen=%s, tab9ueberspringen=%s]",
				klaegerZahl, klWk, beklagtenZahl, bkSwEinheitlich, bkStreitwert, bkGesamt,
				Arrays.toString(bkGesamtIndices), bkGesamtUnterliegen, bkUnterliegen, bkWiderklaegerIndex, dwbkZahl,
				wkSwEinheitlich, wkStreitwert, wkGesamt, Arrays.toString(wkGesamtIndices), wkGesamtUnterliegen,
				wkUnterliegen, mitWiderklage, ohneXjustiz, tab1ueberspringen, tab2ueberspringen, tab6ueberspringen,
				tab7ueberspringen, tab9ueberspringen);
	}

}