/*
 * Streitgenossen.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.baumbach;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;

/**
 * {@link UnterContainerKlasse} von {@link VerfahrensDatenContainer} für die Registerkarte
 * Streitgenossen
 *
 * @author Peter Schuster (setrok)
 * @date 27.12.2014
 *
 */
public class Streitgenossen implements UnterContainerKlasse {

	@XmlAttribute(name = "widerklage")
	public boolean widerklage;

	@XmlAttribute(name = "p45i3GKG")
	public boolean wirtschaftlichIdentisch;

	@XmlElement(name = "klaeger")
	public BaumbachBeteiligtenListe klaeger = new BaumbachBeteiligtenListe();

	@XmlElements({ @XmlElement(name = "drittwiderbeklagter", type = BaumbachBeteiligter.class),
			@XmlElement(name = "widerbeklagtenGesamtschuldnerschaft", type = BaumbachGesamtschuldnerschaft.class) })
	@XmlElementWrapper(name = "drittwiderbeklagtenListe")
	public BaumbachBeteiligtenListe drittwiderbeklagte = new BaumbachBeteiligtenListe();

	@XmlElements({ @XmlElement(name = "beklagter", type = BaumbachBeteiligter.class),
			@XmlElement(name = "beklagtenGesamtschuldnerschaft", type = BaumbachGesamtschuldnerschaft.class) })
	@XmlElementWrapper(name = "beklagtenListe")
	public BaumbachBeteiligtenListe beklagte = new BaumbachBeteiligtenListe();
}