/*
 * Beschriftung.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.beschriftungen;

import java.awt.event.KeyEvent;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

/**
 * Eigentliche Grundklasse „Beschriftung“ mit weiterem Feldern String title
 * (XmlAttribute) und String shortDescription (XmlElement),
 *
 * @author Peter Schuster (setrok)
 * @date 03.08.2019
 *
 */
public class Beschriftung extends NameContainer {
	private static final long serialVersionUID = -4248042144432161109L;
	private String title;
	private String shortDescription;
	private int mnemonic = 0;


	/**
	 * The key used for storing the <code>String</code> name for the action, used
	 * for a menu or button.
	 * 
	 * @return gibt {@link #title} als {@link String} zurück.
	 */
	@XmlAttribute
	public String getTitle() {
		return title;
	}

	/**
	 * @param title d. {@link #getTitle()}, d. gesetzt werden soll als
	 *              {@link String}.
	 * @return
	 */
	public Beschriftung setTitle(String title) {
		this.title = title;
		return this;
	}

	/**
	 * The key used for storing a short <code>String</code> description for the
	 * action, used for tooltip text.
	 * 
	 * @return gibt {@link #shortDescription} als {@link String} zurück.
	 */
	@XmlElement
	public String getShortDescription() {
		return shortDescription;
	}

	/**
	 * @param shortDescription d. {@link #getShortDescription()}, d. gesetzt werden
	 *                         soll als {@link String}.
	 */
	public void setShortDescription(String shortDescription) {
		this.shortDescription = shortDescription;
	}
	//ComponentBeschrifter.deWhiteSpace(shortDescription)

	/**
	 * Speichert das Tastaturkürzel für das beschriftete Element als {@link String}
	 * (da {@link JAXB} nicht mit {@link Character} bzw. char umgehen kann). Java
	 * geht in {@link KeyEvent#getKeyCode()} eigentlich von {@link Integer}-Werten
	 * aus. Während die durch Konstanten (etwa {@link KeyEvent#VK_A}) im Java-Code
	 * recht gut zu lesen sind, würden im XML-Code nur Zahlenwerte stehen. Deshalb
	 * wird die Char gespeichert.
	 * 
	 * Siehe auch {@link #mnemonicIntValue()}, um direkt den int-Wert zu erhalten.
	 * 
	 * @return gibt {@link #mnemonic} als {@link String} zurück.
	 */
	@XmlAttribute(name = "mnemonicChar")
	public String getMnemonic() {
		if (hasMnemonic()) {
			return KeyEvent.getKeyText(mnemonic);
		} else
			return null;
	}

	/**
	 * Siehe {@link #setMnemonic(int)}, um direkt den int-Wert zu setzen.
	 * 
	 * @param mnemonic d. {@link #getMnemonic}, d. gesetzt werden soll als
	 *                 {@link String}.
	 */
	public void setMnemonic(String chars) {
		if (chars != null && !chars.isEmpty()) {
			setMnemonic(KeyEvent.getExtendedKeyCodeForChar(chars.charAt(0)));
		} else
			setMnemonic(0);
	}

	/**
	 * Die Methode prüft, ob ein {@link #getMnemonic()} vorhanden ist.
	 * 
	 * @return ob ein {@link #getMnemonic()} vorliegt.
	 */
	public boolean hasMnemonic() {
		return mnemonicIntValue() != 0;
	}

	public int mnemonicIntValue() {
		return mnemonic;
	}

	public void setMnemonic(int mnemonic) {
		this.mnemonic = mnemonic;
	}
}
// baueHtmlTooltip(getTitle(), )

/*
 * Die Methode baut einen kurzen HTML-Tooltip mit einer Überschrift und der
 * Kurzbeschriftung. Zeilenumbrüche werden durch HTML-Code ersetzt.
 * 
 * @param header The key used for storing the {@link String} name for the
 * action, used for a menu or button.
 * 
 * @param shortDescription The key used for storing a short {@link String}
 * description for the action, used for tooltip text.
 * 
 * @return einen HTML-Text public static String baueHtmlTooltip(String header,
 * String shortDescription) { if (shortDescription != null &&
 * !shortDescription.toLowerCase().contains("<html>")) { shortDescription =
 * shortDescription.replace("\n", "<br>"); shortDescription =
 * String.format("<html><h3>%s</h3><p>%s</p></html>", header, shortDescription);
 * } return shortDescription; }
 */

/*
 * Ruft super.applyTo auf und setzt weiter den Text/Title/Label und die
 * shortDescription/toolTip.
 * 
 * @param comp eine {@link JComponent}
 * @return dieselbe {@link JComponent}
 * @throws IllegalArgumentException wenn {@link JComponent} null ist
 * 
 * @see eu.gronos.kostenrechner.model.beschriftungen.NameContainer#applyTo(java.awt.Component,
 *      ComponentBeschrifter)
 */
//@Override
//public Component applyTo(Component comp, ComponentBeschrifter beschrifter) throws IllegalArgumentException {
	//return beschrifter.beschreibe(comp, this);
//}
// super.applyTo(comp, beschrifter);
// if (comp instanceof JLabel) {
// ((JLabel) comp).setText(getTitle());
// if (hasMnemonic())
// ((JLabel) comp).setDisplayedMnemonic(mnemonicIntValue());
// } else if (comp instanceof JCheckBoxMenuItem || comp instanceof JMenuItem ||
// comp instanceof JCheckBox) {
// ((AbstractButton) comp).setText(getTitle());
// if (hasMnemonic())
// ((AbstractButton) comp).setMnemonic(mnemonicIntValue());
// } else if (comp instanceof JPanel || comp instanceof JScrollPane) {
// if (((JComponent) comp).getBorder() instanceof TitledBorder) {
// ((TitledBorder) ((JComponent) comp).getBorder()).setTitle(getTitle());
// }
// } else if (comp instanceof JDialog) {
// ((JDialog) comp).setTitle(getTitle());
// } else if (comp instanceof JFrame) {
// ((JFrame) comp).setTitle(getTitle());
// } else {
// if (comp.getAccessibleContext() != null) {
// comp.getAccessibleContext().setAccessibleName(getTitle());
// }
// }
// if (comp instanceof JComponent)
// ((JComponent) comp).setToolTipText(getShortDescription());
// //HTML-Code in der AccessibleDescription verwirrt assistive Technik
// comp.getAccessibleContext().setAccessibleDescription(getShortDescription());
// return comp;