/*
 * ConfigSchluessel.java
 * eu.gronos.kostenrechner.model.beschriftungen (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.beschriftungen;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

import eu.gronos.kostenrechner.controller.system.PreferencesConfigOption;

/**
 * 
 * Parameter-Objekt für von {@link PreferencesConfigOption} abgeleiteten Klassen
 *
 * @author Peter Schuster (setrok)
 * @date 31.01.2020
 *
 * @param <E> der Typ des Schlüssels in der Registry bzw. den Preferences, z.B.
 *            {@link String} oder {@link Boolean}
 */
public abstract class ConfigSchluessel<E> {

	private String schluessel;

	/**
	 * einfacher Konstruktor für {@link JAXB}
	 * 
	 */
	public ConfigSchluessel() {
		super();
	}

	/**
	 * @param schluessel der Schlüssel im Unterast
	 *                   <code>"/eu/gronos/kostentenor"</code> (String)
	 * 
	 */
	public ConfigSchluessel(String schluessel) {
		this();
		setSchluessel(schluessel);
	}

	/**
	 * @return gibt {@link #schluessel} als {@link String} zurück, das ist der
	 *         Schlüssel im Unterast <code>"/eu/gronos/kostentenor"</code> als
	 *         {@link String}.
	 */
	@XmlAttribute(name = "schluessel")
	public String getSchluessel() {
		return schluessel;
	}

	/**
	 * @param schluessel d. {@link #schluessel}, d. gesetzt werden soll als
	 *                   {@link String}.
	 */
	public void setSchluessel(String schluessel) {
		this.schluessel = schluessel;
	}

	/**
	 * @return gibt {@link #standardWert} als {@link boolean} zurück, das ist der
	 *         Standard-Wert als {@link Object}, falls der Schlüssel noch nicht
	 *         angelegt ist.
	 */
	@XmlTransient
	public abstract E getStandardWert();

	/**
	 * @param standardWert d. {@link #standardWert}, d. gesetzt werden soll als
	 *                     {@link Object}.
	 */
	public abstract void setStandardWert(E standardWert);

}