/*
 * LangBeschriftung.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.beschriftungen;

import java.awt.event.ActionEvent;
import java.net.URL;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

import eu.gronos.kostenrechner.controller.ComponentBeschrifter;
import eu.gronos.kostenrechner.interfaces.Bebildert;

/**
 * von Beschriftung abgeleitete Klasse „LangBeschriftung“ mit dem zusätzlichen
 * Feld String/Element longDescription (XmlElement) und ggfs URL img
 * (XmlAttribute). Nicht den Shortkey, auch nicht den AcceleratorKey, das ist
 * jeweils ein int und wäre bei einem Export dann nur noch eine Zahl (aber auch
 * zentral sammeln). JButton und Action haben dieselbe ID
 *
 * @author Peter Schuster (setrok)
 * @date 03.08.2019
 *
 */
public class LangBeschriftung extends Beschriftung implements Bebildert {
	private static final long serialVersionUID = 2299722526230365280L;
	private String longDescription = null;
	private String actionCommandKey = null;
	private TastenKombination acceleratorKey = null;
	private String image;

	/**
	 * Setzt die values der Action.
	 * 
	 * @param beschrifter TODO
	 */
	public Action applyTo(Action action, ComponentBeschrifter beschrifter) {
		return beschrifter.beschrifte(action, this);
	}

	/**
	 * The key used for storing a longer <code>String</code> description for the
	 * action, could be used for context-sensitive help.
	 * 
	 * @return gibt {@link #longDescription} als {@link String} zurück.
	 */
	@XmlElement
	public String getLongDescription() {
		return longDescription;
	}

	/**
	 * @param longDescription d. {@link #getLongDescription()}, d. gesetzt werden
	 *                        soll als {@link String}.
	 */
	public void setLongDescription(String longDescription) {
		if (longDescription != null)
			this.longDescription = longDescription.trim().replaceAll("\\s+", " ");
		else
			this.longDescription = null;
	}

	/**
	 * 
	 * @return gibt {@link #actionCommandKey} als {@link String} zurück.
	 *         ({@link javax.swing.Action#ACTION_COMMAND_KEY}) The key used to
	 *         determine the command String for the {@link ActionEvent} that will be
	 *         created when an {@link Action} is going to be notified as the result
	 *         of residing in a Keymap associated with a {@link JComponent}.
	 */
	@XmlAttribute(name = "key")
	public String getActionCommandKey() {
		return actionCommandKey;
	}

	/**
	 * @param actionCommandKey d. {@link #getActionCommandKey()}, d. gesetzt werden
	 *                         soll als {@link String}.
	 */
	public void setActionCommandKey(String actionCommandKey) {
		this.actionCommandKey = actionCommandKey;
	}

	/**
	 * The key used for storing an <code>Icon</code>. This is typically used by
	 * buttons, such as <code>JButton</code> and <code>JToggleButton</code>.
	 * 
	 * @return gibt {@link #image} als {@link String} zurück, denn {@link URL} geht
	 *         nicht.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Bebildert#getImage()
	 */
	@XmlAttribute(name = "img")
	public String getImage() {
		return image;
	}

	/**
	 * @param img d. {@link #image}, d. gesetzt werden soll als {@link String}.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Bebildert#setImage(java.lang.String)
	 */
	public void setImage(String img) {
		this.image = img;
	}

	/**
	 * @return gibt {@link #acceleratorKey} als {@link TastenKombination} zurück.
	 */
	@XmlElement(name = "accelerator")
	public TastenKombination getAcceleratorKey() {
		return acceleratorKey;
	}

	/**
	 * @param acceleratorKey d. {@link #acceleratorKey}, d. gesetzt werden soll als
	 *                       {@link TastenKombination}.
	 */
	public void setAcceleratorKey(TastenKombination acceleratorKey) {
		this.acceleratorKey = acceleratorKey;
	}

	@Override
	public String toString() {
		return String.format(
				"LangBeschriftung [id()=%s, title()=%s, actionCommandKey=%s, shortDescription()=%s, longDescription=%s, image=%s]",
				getId(), getTitle(), actionCommandKey, getShortDescription(), longDescription, image);
	}
//, checkable, checkable=%s
}

// private boolean checkable = false;

/*
 * Die Methode wendet die Beschriftung auf eine {@link JComponent} an.
 * 
 * @param comp die {@link Component}
 * 
 * @return dieselbe {@link Component}
 * 
 * @throws IllegalArgumentException wenn {@link JComponent} <code>null</code>
 * ist.
 * 
 * @see
 * eu.gronos.kostenrechner.model.beschriftungen.Beschriftung#applyTo(java.awt.
 * Component, ComponentBeschrifter)
 */
//@Override
//public Component applyTo(Component comp, ComponentBeschrifter beschrifter) throws IllegalArgumentException {
//	//super.applyTo(comp, beschrifter);
//	if (comp instanceof AbstractButton) {
//		final AbstractButton button = (AbstractButton) comp;
//		if (button.getAction() != null) {
//			applyTo(button.getAction(), beschrifter);
//		} else {
//			button.setText(super.getTitle());
//			if (hasMnemonic())
//				((AbstractButton) comp).setMnemonic(mnemonicIntValue());
//			button.setActionCommand(getActionCommandKey());
//			if (getImage() != null)
//				button.setIcon(RechnerhammerIcons.loadIcon(getImage()));
//			// new ImageIcon(getClass().getClassLoader().getResource(this.getImage())));
//			if (button instanceof JMenuItem && getAcceleratorKey() != null) {
//				((JMenuItem) button).setAccelerator(getAcceleratorKey().toKeyStroke());
//			}
//		}
//	}
// return comp;
//}
// Beschriftung.baueHtmlTooltip(super.getTitle(), )
/*
 * action.putValue(Action.NAME, super.getTitle());
 * action.putValue(Action.SHORT_DESCRIPTION, super.getShortDescription()); if
 * (getLongDescription() != null) action.putValue(Action.LONG_DESCRIPTION,
 * getLongDescription()); if (getActionCommandKey() != null)
 * action.putValue(Action.ACTION_COMMAND_KEY, getActionCommandKey()); if
 * (getImage() != null) { ImageIcon ii =
 * RechnerhammerIcons.loadIcon(getImage()); // new
 * ImageIcon(getClass().getClassLoader().getResource(this.getImage()));
 * ii.setDescription(this.getImage()); action.putValue(Action.LARGE_ICON_KEY,
 * ii); } if (hasMnemonic())// getMnemonic() != null
 * action.putValue(Action.MNEMONIC_KEY, Integer.valueOf(mnemonicIntValue())); if
 * (getAcceleratorKey() != null) action.putValue(Action.ACCELERATOR_KEY,
 * getAcceleratorKey().toKeyStroke()); return action;
 */

/*
 * @return gibt {@link #checkable} als {@link boolean} zurück, also ob es sich
 * um ein {@link JCheckBoxMenuItem} oder einen {@link JToggleButton} handelt.
 * 
 * @XmlAttribute(name = "checker") public boolean isCheckable() { return
 * checkable; }
 */

/*
 * @param checkable d. {@link #checkable}, d. gesetzt werden soll als {@link
 * boolean}.
 * 
 * public void setCheckable(boolean checkable) { this.checkable = checkable; }
 */