/*
 * LangVorsorgeBeschriftung.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.beschriftungen;

import java.util.ArrayList;
import java.util.List;

import javax.swing.Action;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.kostenrechner.interfaces.Vorsorgend;

/**
 * Eine von {@link LangVorsorgeBeschriftung} abgeleitete Klasse mit einer
 * List<String> alternateTitles und auch alternateDescriptions für Elemente, die
 * ihre Beschriftung zwischendurch wechseln, vorsorgend weil es eine Reserve an
 * Strings hat
 * 
 * @author Peter Schuster (setrok)
 * @date 05.08.2019
 *
 */
public class LangVorsorgeBeschriftung extends LangBeschriftung implements Vorsorgend<LangVorsorgeBeschriftung> {
	private static final long serialVersionUID = -2627581964285739761L;
	/*
	 * Die Listen müssen je einmal angelegt werden, sonst hat der Unmarshaller
	 * Probleme
	 */
	private List<String> alternativeTitles = new ArrayList<String>();
	private List<String> alternativeDescriptions = new ArrayList<String>();
	private boolean formatted = false;

	/**
	 * 
	 * @return gibt {@link #alternativeTitles} als
	 *         {@link List}&lt;{@link String}&gt; zurück. Das ist eine vorsorgend
	 *         bereitgehaltene Liste anderer Titel, die die {@link Action} in
	 *         anderen Zuständen tragen kann.
	 */
	@Override
	@XmlElementWrapper(name = "alternativeTitles")
	@XmlElements({ @XmlElement(name = "alternativeTitle", type = String.class) })
	public List<String> getAlternativeTitles() {
		return alternativeTitles;
	}

	/**
	 * @param alternativeTitles d. {@link #alternativeTitles}, d. gesetzt werden
	 *                          soll als {@link List}&lt;{@link String}&gt;.
	 */
	@Override
	public void setAlternativeTitles(List<String> alternativeTitles) {
		this.alternativeTitles = new ArrayList<String>();// LinkedList
		// alternativeTitles;
		for (String title : alternativeTitles) {
			this.alternativeTitles.add(title);
		}
	}// ComponentBeschrifter.deWhiteSpace()

	/**
	 * @return gibt {@link #alternativeDescriptions} als
	 *         {@link List}&lt;{@link String}&gt; zurück. Das ist eine vorsorgend
	 *         bereitgehaltene Liste anderer Beschreibungen, die die {@link Action}
	 *         in anderen Zuständen tragen kann.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#getAlternativeDescriptions()
	 */
	@Override
	@XmlElementWrapper(name = "alternativeDescriptions")
	@XmlElements({ @XmlElement(name = "alternativeDescription", type = String.class) })
	public List<String> getAlternativeDescriptions() {
		return alternativeDescriptions;
	}

	/**
	 * @param alternativeDescriptions d. {@link #getAlternativeDescriptions}, d.
	 *                                gesetzt werden soll als
	 *                                {@link List}&lt;{@link String}&gt;.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#setAlternativeDescriptions(java.util.List)
	 */
	@Override
	public void setAlternativeDescriptions(List<String> alternativeDescriptions) {
		this.alternativeDescriptions = new ArrayList<String>();// LinkedList
		for (String description : alternativeDescriptions) {
			this.alternativeDescriptions.add(description);
		}
	}// ComponentBeschrifter.deWhiteSpace()

	/**
	 * @return gibt als {@link boolean} zurück, also ob die
	 *         {@link #getAlternativeTitles()} den {@link Beschriftung#getTitle()}
	 *         mit {@link String#format(String, Object...)} bilden sollen.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#isFormatted()
	 */
	@Override
	@XmlAttribute(name="formatted")
	public boolean isFormatted() {
		return formatted;
	}

	/**
	 * @param formatted d. {@link #formatted}, d. gesetzt werden soll als
	 *                  {@link Boolean}.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#setFormatted(boolean)
	 */
	@Override
	public void setFormatted(boolean formatted) {
		this.formatted = formatted;
	}

}

/*
 * Die Methode setzt einen {@link #getTitle()} aus den vorhandenen {@link
 * #getAlternativeTitles()} und die {@link #getShortDescription()} aus den
 * {@link #getAlternativeDescriptions()}. Danach muss applyTo() aufgerufen
 * werden.
 * 
 * @param index der Index des neuen Titles
 * 
 * @return die {@link LangVorsorgeBeschriftung} mit dem neuen {@link
 * Beschriftung#getTitle()} und der neuen {@link
 * Beschriftung#getShortDescription()}
 * 
 * @see
 * eu.gronos.kostenrechner.interfaces.Vorsorgend#changeTo(ComponentBeschrifter,
 * int)
 */
//public LangVorsorgeBeschriftung changeTo(int index, ComponentBeschrifter beschrifter) {
// beschrifter.changeTitle(this, index);
// beschrifter.changeDescription(this, index);
// return this;// super.getTitle();
//}

/*
 * Die Methode setzt einen {@link #getTitle()} aus den vorhandenen {@link
 * #getAlternativeTitles()} und die {@link #getShortDescription()} aus den
 * {@link #getAlternativeDescriptions()}, sofern der Titel enthalten ist. Danach
 * muss applyTo() aufgerufen werden.
 * 
 * @param title den {@link Beschriftung#getTitle()}, der herausgesucht werden
 * soll
 * 
 * @return <code>true</code>, wenn er in {@link #getAlternativeTitles()}
 * gefunden wird
 * 
 * @see
 * eu.gronos.kostenrechner.interfaces.Vorsorgend#changeTo(ComponentBeschrifter,
 * java.lang.String)
 */
//public boolean changeTo(String title, ComponentBeschrifter beschrifter) {
// for (int index = 0; index < getAlternativeTitles().size(); index++) {
// if (getAlternativeTitles().get(index).contains(title)) {
// changeTo(index, beschrifter);
// return true;
// }
// }
// Kostenrechner.getLogger().info(String.format("Beschriftung nicht gefunden:
// '%s'", title));
// return false;
//}
//@Override
//public Component applyTo(Component comp, ComponentBeschrifter beschrifter) throws IllegalArgumentException {
// Listeners?
// super.applyTo(comp, beschrifter);
// return comp;
//}