/*
 * NameMap.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.beschriftungen;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.JAXB;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;

/**
 * Beschriftungen in HashMap oä organisieren, damit man alles über die id
 * abrufen kann.
 */
public class NameContainerMap extends HashMap<Integer, NameContainer> {
	private static final long serialVersionUID = 8156338816766505017L;
	public static long start;
	public static long end;
	public NameContainerMap() {
		super();
	}

	/**
	 * Konstruktor mit ressource
	 * 
	 * @param dateiname "resources/beschriftungen.xml"
	 */
	public NameContainerMap(String dateiname) {
		super();
		initFromFile(dateiname);
	}

	/**
	 * Die Methode liest die XML-Datei und konvertiert sie in eine {@link Map}
	 * mittels {@link NameContainerMapWrapper} und {@link NameContainerMapAdapter}.
	 * 
	 * @param dateiname den Dateinamen für
	 *                  {@link ClassLoader#getResourceAsStream(String)}
	 */
	private void initFromFile(String dateiname) {
		start = Kostenrechner.systemDefaultZone.millis();

		InputStream stream = getClass().getClassLoader().getResourceAsStream(dateiname);
		if (stream == null)
			throw new NullPointerException(
					String.format("Der InputStream für '%s' ist null, Datei nicht vorhanden?", dateiname));

		try {
			NameContainerMapWrapper wrap = JAXB.unmarshal(stream, NameContainerMapWrapper.class);
			NameContainerMapAdapter adapter = new NameContainerMapAdapter();
			NameContainerMap map = adapter.unmarshal(wrap);
			putAll(map);
		} catch (Throwable error) {
			FehlerHelper.zeigeFehler("Fehler beim Einlesen der Oberflächenbeschriftung!", error);
		}

		end = Kostenrechner.systemDefaultZone.millis();
	}
}
//for (Component comp : menu.getComponents()) {
//if (comp != null) {
//	NameContainer cont = buildFrom(comp, zaehler);
//	if (cont != null)
//		set.add(cont);
//}
//zaehler++;
//}

//public static Set<NameContainer> buildFromM(JMenu menu, int zaehler) {
//Set<NameContainer> set = new TreeSet<NameContainer>();
//int i = 0;
//try {
//while (true) {
//	JMenuItem comp = menu.getItem(i);
//	if (comp != null) {
//		NameContainer cont = buildFrom(comp, zaehler);
//		if (cont != null)
//			set.add(cont);
//	}
//	zaehler++;
//	i++;
//}
//} catch (Exception e) {
//e.printStackTrace();
//}
//return set;
//}

//		if (dialog instanceof HinzufuegenDialog<?>) {
//			set.addAll(buildFrom(zaehler, ((HinzufuegenDialog<?>) dialog).getButtonPane().getComponents()));
//		}
//		zaehler += set.size();
//		set.addAll(buildFrom(zaehler, dialog.getRootPane().getComponents()));
//		zaehler += set.size();
//		final ActionMap actionMap = dialog.getRootPane().getActionMap();
//		for (Object key : actionMap.allKeys()) {
//			final Action action = actionMap.get(key);
//			if (action != null) {
//				final LangBeschriftung beschriftung = buildFrom(action);
//				if (beschriftung.getId() == null)
//					beschriftung.setId(Integer.valueOf(zaehler).toString());
//				set.add(beschriftung);
//				// beschriftung.setId(Integer.valueOf(beschriftung.getId().hashCode()).toString());
//			}
//		}
// new ArrayList<JComponent>();
// for (Component comp : components) {
// if (comp instanceof JComponent) {
// comps.add((JComponent) comp);
// JComponent jc = (JComponent) comp;
// final Component[] components2 = ;
// comps.addAll(toList(components2));
// comps.addAll(toList(((JComponent) comp).getComponents()));
// }
// }
//		if (comp instanceof JCheckBox) {
//			cont = new Beschriftung();
//			// cont = buildFrom(((AbstractButton) comp).getAction());
//			((Beschriftung) cont).setShortDescription(((JComponent) comp).getToolTipText());
//		} else if (comp instanceof JLabel) {
//			cont = new Beschriftung();
//			((Beschriftung) cont).setShortDescription(((JComponent) comp).getToolTipText());
//		} else if (comp instanceof AbstractButton) {
//			cont = buildFrom(((AbstractButton) comp).getAction());
//		} else

/*
 * Die Methode dient dazu, das {@link NameContainerMap#getBeSchreibSet()} in
 * eine Map zu wandeln
 * 
 * @param map eine (leere) {@link NameContainerMap}, aus der sich die Methode
 * auch das {@link NameContainerMap#getBeSchreibSet()} zieht.
 * 
 * @param beSchreibSet {@link #getBeSchreibSet()}
 * 
 * @return dieselbe {@link NameContainerMap}, allerdings mit Werten.
 */
//private Map<Integer, NameContainer> convertToMap(NameContainerMap map, Set<NameContainer> beSchreibSet) {
// for (NameContainer b : beSchreibSet) {
// map.put(b.getKey(), b);// Integer.valueOf(b.idIntValue())
// }
// Kostenrechner.getLogger().info
// System.out.println((String.format("Einlesen von %d dauerte %d ms.", (end -
// start))));
// return map;
//}
//convertToMap(this, readFromStream(stream).getBeSchreibSet());		
//@XmlRootElement(name = "beschriftungsSammlung")
//@XmlAccessorType(XmlAccessType.PROPERTY)
//private Set<NameContainer> beSchreibSet = new HashSet<NameContainer>();
/*
 * @return gibt {@link #beSchreibSet} als {@link Set<NameContainer>} zurück.
 * 
 * @XmlElements({ @XmlElement(name = "nurname", type = NameContainer.class),
 * 
 * @XmlElement(name = "beschriftung", type = Beschriftung.class),
 * 
 * @XmlElement(name = "langVorsorgend", type = LangVorsorgeBeschriftung.class),
 * 
 * @XmlElement(name = "langBeschriftung", type = LangBeschriftung.class),
 * 
 * @XmlElement(name = "vorsorgend", type = VorsorgendeBeschriftung.class),
 * 
 * @XmlElement(name = "ohneTitel", type = UnBeschriftung.class) })
 * 
 * @XmlElementWrapper(name = "beschriftungen")
 */
//public Set<NameContainer> getBeSchreibSet() {
//	return beSchreibSet;
//}
/*
 * @param beSchreibSet d. {@link #beSchreibSet}, d. gesetzt werden soll als
 * {@link List<NameContainer>}.
 * 
 ***/
//public void setBeSchreibSet(Set<NameContainer> beSchreibSet) {
//  this.beSchreibSet = beSchreibSet; }
// NameContainerMapWrapper wrap = new
// NameContainerMapWrapper(readFromStream(stream).getBeSchreibSet());

/*
 * Hier wird die XML-Datei gelesen. ressource einlesen
 * 
 * @param stream ein {@link InputStream}
 * 
 * @return ein {@link NameContainerMapWrapper}
 */
//private NameContainerMapWrapper readFromStream(InputStream stream) {
//	if (stream == null)
//		throw new NullPointerException("Der InputStream für die angegebene Resource darf nicht null sein.");
//	NameContainerMapWrapper wrap = JAXB.unmarshal(stream, NameContainerMapWrapper.class);
//	return wrap;
//}

//private NameContainerMap readFromStream(InputStream stream) {
//	if (stream == null)
//		throw new NullPointerException("Der InputStream für die angegebene Resource darf nicht null sein.");
//	NameContainerMap map = JAXB.unmarshal(stream, NameContainerMap.class);
//	return map;
//}
// "Der InputStream für die angegebene Resource darf nicht null sein."
//				
//		long start = System.currentTimeMillis();
//		tester.setDauer( - start);//System.currentTimeMillis();
// Auto-generated catch block
// System.err.println(e.getLocalizedMessage());e.printStackTrace();