/*
 * NameContainerMapWrapper.java
 * eu.gronos.kostenrechnertest.guitest (Kostenrechner Test)
 */
package eu.gronos.kostenrechner.model.beschriftungen;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Die Klasse dient dem Xml-Export einer {@link NameContainerMap} über ein
 * {@link Set} aus {@link NameContainer}n. Das ist gefahrlos möglich, da der
 * Bestandteil des Elements, {@link NameContainer#getId()}, gleichzeitig auch
 * der Key für die {@link Map} ist.
 * 
 * Die Klasse trägt die {@link XmlRootElement}-Annotation statt der
 * {@link NameContainerMap}, weil es das {@link Set} eigentlich nur zum
 * {@link JAXB}-Import bzw. -Export braucht.
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2019
 *
 */
@XmlRootElement(name = "beschriftungsSammlung")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class NameContainerMapWrapper {

	private Set<NameContainer> beSchreibSet = new TreeSet<NameContainer>();

	/**
	 * Konstruktor für {@link JAXB}
	 * 
	 */
	public NameContainerMapWrapper() {
		super();
	}

	/**
	 * Konstruktor, um gleich das {@link #getBeSchreibSet()} mitzusetzen
	 * 
	 * @param beSchreibSet das {@link #getBeSchreibSet()} als {@link Set} aus
	 *                     {@link NameContainer}n
	 */
	public NameContainerMapWrapper(Set<NameContainer> beSchreibSet) {
		this();
		setBeSchreibSet(beSchreibSet);
	}

	/**
	 * @return gibt {@link #beSchreibSet} als {@link Set} aus {@link NameContainer}n
	 *         zurück.
	 */
	@XmlElements({ @XmlElement(name = "nurname", type = NameContainer.class),
			@XmlElement(name = "beschriftung", type = Beschriftung.class),
			@XmlElement(name = "configBechriftung", type = SchluesselBeschriftung.class),
			@XmlElement(name = "langVorsorgend", type = LangVorsorgeBeschriftung.class),
			@XmlElement(name = "langBeschriftung", type = LangBeschriftung.class),
			@XmlElement(name = "vorsorgend", type = VorsorgendeBeschriftung.class),
			@XmlElement(name = "nurBild", type = BildOhneTitel.class),
			@XmlElement(name = "ohneTitel", type = UnBeschriftung.class) })
	@XmlElementWrapper(name = "beschriftungen")
	public Set<NameContainer> getBeSchreibSet() {
		return beSchreibSet;
	}

	/**
	 * @param beSchreibSet das {@link #getBeSchreibSet()}, das gesetzt werden soll
	 *                     als {@link Set} aus {@link NameContainer}n.
	 */
	public void setBeSchreibSet(Set<NameContainer> beSchreibSet) {
		this.beSchreibSet = beSchreibSet;
	}

}
