/*
 * SchluesselBeschriftung.java
 * eu.gronos.kostenrechner.model.beschriftungen (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.beschriftungen;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.kostenrechner.controller.system.PreferencesConfigOption;

/**
 * Eine von {@link LangVorsorgeBeschriftung} abgeleitete Klasse, die auch
 * {@link ConfigSchluessel} speichert.
 *
 * @author Peter Schuster (setrok)
 * @date 01.02.2020
 *
 */
public class SchluesselBeschriftung extends LangVorsorgeBeschriftung {
	private static final long serialVersionUID = -888657610607599526L;
	private ConfigSchluessel<?> configSchluessel = null;

	/**
	 * @return gibt {@link #configSchluessel} als ein von
	 *         {@link ConfigSchluessel}&lt;?> abgeleitetes Objekt zurück
	 *         ({@link StringConfigSchluessel} oder
	 *         {@link BooleanConfigSchluessel}), also ein Parameter-Objekt für den
	 *         Zugriff auf eine {@link PreferencesConfigOption}
	 */
	@XmlElements({ @XmlElement(name = "stringConfig", type = StringConfigSchluessel.class),
			@XmlElement(name = "booleanConfig", type = BooleanConfigSchluessel.class),
			@XmlElement(name = "config", type = ConfigSchluessel.class) })
	public ConfigSchluessel<?> getConfigSchluessel() {
		return configSchluessel;
	}

	/**
	 * @param configSchluessel d. {@link #configSchluessel}, d. gesetzt werden soll
	 *                         als {@link ConfigSchluessel<?>}.
	 */
	public void setConfigSchluessel(ConfigSchluessel<?> configSchluessel) {
		this.configSchluessel = configSchluessel;
	}

}
