/*
 * VorsorgendeBeschriftung.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.beschriftungen;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.kostenrechner.interfaces.Vorsorgend;

/**
 * von Beschriftung abgeleitete Klasse „VorsorgendeBeschriftung“ mit einer
 * List<String> alternateTitles (XmlElements/Wrapper) und vielleicht auch
 * alternateDescriptions (XmlElements/Wrapper?) für Elemente, die ihre
 * Beschriftung zwischendurch wechseln, vorsorgend weil es eine Reserve an
 * Strings hat, Wenn ein JLabel zwischendurch geändert wird, zweite Beschriftung
 * speichern, nein besser: Alternativen mitspeichern in VorsorgendeBeschriftung,
 * s.o.
 * 
 * @author Peter Schuster (setrok)
 * @date 03.08.2019
 *
 */
public class VorsorgendeBeschriftung extends Beschriftung implements Vorsorgend<VorsorgendeBeschriftung> {
	private static final long serialVersionUID = 7551783095558692578L;
	/* Die Liste muss einmal angelegt werden, sonst hat der Unmarshaller Probleme */
	private List<String> alternativeTitles = new ArrayList<String>();
	private List<String> alternativeDescriptions = new ArrayList<String>();
	private boolean formatted = false;

	/**
	 * @return gibt {@link #alternativeTitles} als
	 *         {@link List}&lt;{@link String}&gt; zurück. Das ist eine vorsorgend
	 *         bereitgehaltene Liste anderer Titel, die die {@link JComponent} in
	 *         anderen Zuständen tragen kann.
	 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#getAlternativeTitles()
	 */
	@Override
	@XmlElementWrapper(name = "alternativeTitles")
	@XmlElements({ @XmlElement(name = "alternativeTitle", type = String.class) })
	public List<String> getAlternativeTitles() {
		return alternativeTitles;
	}

	/**
	 * @param alternativeTitles d. {@link #alternativeTitles}, d. gesetzt werden
	 *                          soll als {{@link List}&lt;{@link String}&gt;.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#setAlternativeTitles(java.util.List)
	 */
	@Override
	public void setAlternativeTitles(List<String> alternativeTitles) {
		this.alternativeTitles = new ArrayList<String>();// LinkedList
		for (String title : alternativeTitles) {
			this.alternativeTitles.add(title);
		}
	}
	// alternativeTitles;
	// ComponentBeschrifter.deWhiteSpace()

	/**
	 * @return gibt {@link #alternativeDescriptions} als {@link List<String>}
	 *         zurück. Das ist eine vorsorgend bereitgehaltene Liste anderer
	 *         Beschreibungen, die die {@link JComponent} in anderen Zuständen
	 *         tragen kann.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#getAlternativeDescriptions()
	 */
	@Override
	@XmlElementWrapper(name = "alternativeDescriptions")
	@XmlElements({ @XmlElement(name = "alternativeDescription", type = String.class) })
	public List<String> getAlternativeDescriptions() {
		return alternativeDescriptions;
	}

	/**
	 * @param alternativeDescriptions d. {@link #getAlternativeDescriptions}, d.
	 *                                gesetzt werden soll als
	 *                                {@link List}&lt;String&gt;.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#setAlternativeDescriptions(java.util.List)
	 */
	@Override
	public void setAlternativeDescriptions(List<String> alternativeDescriptions) {
		this.alternativeDescriptions = new ArrayList<String>();// LinkedList
		for (String description : alternativeDescriptions) {
			this.alternativeDescriptions.add(description);
		}
	}// ComponentBeschrifter.deWhiteSpace()

	/**
	 * @return gibt als {@link boolean} zurück, also ob die
	 *         {@link #getAlternativeTitles()} den {@link Beschriftung#getTitle()}
	 *         mit {@link String#format(String, Object...)} bilden sollen.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#isFormatted()
	 */
	@Override
	@XmlAttribute(name="formatted")
	public boolean isFormatted() {
		return formatted;
	}

	/**
	 * @param formatted d. {@link #formatted}, d. gesetzt werden soll als
	 *                  {@link boolean}.
	 *                  
	 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#setFormatted(boolean)
	 */
	@Override
	public void setFormatted(boolean formatted) {
		this.formatted = formatted;
	}

}

/*
 * Die Methode setzt einen Title aus den vorhandenen {@link
 * #getAlternativeTitles()}. Danach muss applyTo() aufgerufen werden.
 * 
 * @param index der Index des neuen Titles
 * 
 * @return die {@link VorsorgendeBeschriftung} mit dem neuen {@link
 * Beschriftung#getTitle()}
 * 
 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#changeTo(int,
 * ComponentBeschrifter)
 */
// @Override
// public VorsorgendeBeschriftung changeTo(int index, ComponentBeschrifter
// beschrifter) {
//// changeTitle(index);
// beschrifter.changeTitle(this, index);
// beschrifter.changeDescription(this, index);
// return this;
// }

/*
 * Die Methode setzt einen Title aus den vorhandenen {@link
 * #getAlternativeTitles()}, sofern er enthalten ist. Danach muss applyTo()
 * aufgerufen werden.
 * 
 * @param title den {@link Beschriftung#getTitle()}, der herausgesucht werden
 * soll
 * 
 * @return <code>true</code>, wenn er in {@link #getAlternativeTitles()}
 * gefunden wird
 * 
 * @see eu.gronos.kostenrechner.interfaces.Vorsorgend#changeTo(java.lang.String,
 * ComponentBeschrifter)
 */
// public boolean changeTo(String title, ComponentBeschrifter beschrifter) {
// for (int index = 0; index < getAlternativeTitles().size(); index++) {
// if (getAlternativeTitles().get(index).contains(title)) {
// changeTo(index, beschrifter);
// return true;
// }
// }
// Kostenrechner.getLogger().info(String.format("Beschriftung nicht gefunden:
// '%s'", title));
// return false;
// }

// @Override
// public Component applyTo(Component comp, ComponentBeschrifter beschrifter)
// throws IllegalArgumentException {
// Listeners?
// super.applyTo(comp, beschrifter);
// return comp;
// }
