/*
 * Angriffserfolg.java
 * eu.gronos.kostenrechner.model.forderungen (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.forderungen;

/**
 * Ein Parameterobjekt für das Obsiegen des Klägers in der Hauptsache und auch
 * die vollständige Klageforderung. Ersetzt ein Array double[], bei dem index 0
 * die komplette Klage war (jetzt {@link #getVolleForderung()}) und index 1 die verbleibende Klageforderung für den
 * Tenor (jetzt {@link #getErfolg()}).
 *
 * @author Peter Schuster (setrok)
 * @date 5 Jun 2019
 *
 */
public class Angriffserfolg {

	private final double volleForderung;
	private final double erfolg;// verbleibend

	/**
	 * Konstruktor.
	 * 
	 * @param volleForderung die komplette Klage, war hauptsache[0]
	 * @param erfolg         die verbleibende Klageforderung für den Tenor, war
	 *                       hauptsache[1]
	 */
	public Angriffserfolg(double volleForderung, double erfolg) {
		this.volleForderung = volleForderung;
		this.erfolg = erfolg;
	}

	/**
	 * @return gibt {@link #volleForderung} als {@link double} zurück, die komplette
	 *         Klage, war hauptsache[0].
	 */
	public double getVolleForderung() {
		return volleForderung;
	}

	/**
	 * @return gibt {@link #erfolg} als {@link double} zurück, die verbleibende
	 *         Klageforderung für den Tenor, war hauptsache[1]
	 */
	public double getErfolg() {
		return erfolg;
	}

}
