/*
 * ForderungsStaffelung.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.forderungen;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;

/**
 * {@link UnterContainerKlasse} von {@link VerfahrensDatenContainer} für die Registerkarte
 * Staffelung
 *
 * @author Peter Schuster (setrok)
 * @date 27.12.2014
 *
 */
public class ForderungsStaffelung implements UnterContainerKlasse {
	@XmlElement(name = "partei")
	@XmlElementWrapper(name = "parteien")
	public List<Beteiligter> parteien = new ArrayList<Beteiligter>();

	@XmlElements({ @XmlElement(name = "klage", type = KlageForderung.class),
			@XmlElement(name = "aufrechnung", type = AufrechnungsForderung.class) })
	@XmlElementWrapper(name = "forderungen")
	public ArrayList<Forderung> forderungen = new ArrayList<Forderung>();
}