/**
 * AnwaltsGebuehrenTabelle.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.gebuehren;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;

import javax.xml.bind.JAXB;

/**
 * Das ist eine Klasse, um Gebührenhöhe und -sätze nach dem RVG zu berechnen und
 * zu speichern (also Rechtsanwaltsgebühren).
 * 
 * § 13 RVG Wertgebühren (1) Wenn sich die Gebühren nach dem Gegenstandswert
 * richten, beträgt die Gebühr bei einem Gegenstandswert bis 500 Euro 45 Euro.
 * Die Gebühr erhöht sich bei einem
 * 
 * Gegenstandswert bis ... Euro, für jeden angefangenen Betrag von weiteren ...
 * Euro, um ... Euro
 * 
 * 2000, 500, 35
 * 
 * 10000, 1000, 51
 * 
 * 25000, 3000, 46
 * 
 * 50000, 5000, 75
 * 
 * 200000, 15000, 85
 * 
 * 500000, 30000, 120
 * 
 * über 500000, 50000, 150
 * 
 * (2) Der Mindestbetrag einer Gebühr ist 15 Euro.
 * 
 * @author Peter Schuster (setrok)
 * @date 12.01.2014
 * 
 */
public class AnwaltsGebuehrenTabelle extends GebuehrenTabelle {

	public static final String GESETZ = "Rechtsanwaltsvergütungsgesetz (RVG)";
	public static long start;
	public static long end;

	/**
	 * Der Konstruktor ruft den Konstruktor der Oberklasse auf. Ein
	 * Gültigkeitszeitraum wird nicht festgelegt. Zudem initialisiert er mittels
	 * {@link eu.gronos.kostenrechner.model.gebuehren.AnwaltsGebuehrenTabelle#fuelleTabelle()}
	 * die Gebührentabelle.
	 * 
	 * @see eu.gronos.kostenrechner.model.gebuehren.GebuehrenTabelle#GebuehrenTabelle(long,long,Calendar,Calendar)
	 */
	public AnwaltsGebuehrenTabelle() {
		super();
		// war rvg.xml einlesen
		start = System.currentTimeMillis();
		InputStream stream = getClass().getClassLoader().getResourceAsStream("resources/rvg.xml");
		GebuehrenTabelle tab = super.readFromStream(stream);
		setTabelle(tab.getTabelle());
//		setTabelle(readTabelleFromStream(stream));
		setVerzeichnis(tab.getVerzeichnis());
//		setVerzeichnis(new VerguetungsVerzeichnis());
		end = System.currentTimeMillis();	
	}

	/**
	 * Der Konstruktor ruft den Konstruktor der Oberklasse auf. Zudem initialisiert
	 * er mittels {@link GebuehrenTabelle#readTabelleFromStream(InputStream)} und
	 * {@link #setTabelle(ArrayList)} mittels XML-Datei und {@link JAXB} die Werte
	 * der Tabelle.
	 * 
	 * @param stream ein {@link InputStream} von einer XML-Datei für {@link JAXB}
	 */
	public AnwaltsGebuehrenTabelle(InputStream stream) {
		super();
//		setTabelle(readTabelleFromStream(stream));
		GebuehrenTabelle tab = super.readFromStream(stream);
		setTabelle(tab.getTabelle());
		setVerzeichnis(tab.getVerzeichnis());
	}
}
