/*
 * GebuehrenBerechnung.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.gebuehren;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;

/**
 * {@link UnterContainerKlasse} von {@link VerfahrensDatenContainer} für die Registerkarte Freie
 * Gebührenberechnung
 *
 * @author Peter Schuster (setrok)
 * @date 27.12.2014
 *
 */
public class GebuehrenBerechnung implements UnterContainerKlasse {
	@XmlAttribute(name = "streitwert")
	public long streitwert;

	// public GebuehrenTatbestand[] gebuehren = new
	// GebuehrenTatbestand[0];List<GebuehrenTatbestand>
	@XmlElements({ @XmlElement(name = "anrechnung", type = GebuehrenAnrechnungsTatbestand.class),
			@XmlElement(name = "wertrahmen", type = GebuehrenRahmenTatbestand.class),
			@XmlElement(name = "gebuehrenSatz", type = GebuehrenSatzTatbestand.class),
			@XmlElement(name = "mehrpauschale", type = MehrfachPauschalTatbestand.class),
			@XmlElement(name = "auslagen", type = AuslagenTatbestand.class),
			@XmlElement(name = "pauschale", type = PauschalTatbestand.class),
			@XmlElement(name = "steuer", type = MehrwertsteuerTatbestand.class),
			@XmlElement(name = "erhoehungsSatz", type = GebuehrenErhoehungsTatbestand.class) })
	@XmlElementWrapper(name = "gebuehren")
	public GebuehrenVerzeichnis gebuehren = new GebuehrenVerzeichnis();// ArrayList<GebuehrenTatbestand>();
}