/*
 * GebuehrenGesetzesSammlung.java
 * eu.gronos.kostenrechner.model.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.gebuehren;

import eu.gronos.kostenrechner.Kostenrechner;

/**
 * Diese Klasse hat nur den Sinn, {@link AnwaltsGebuehrenTabelle} und
 * {@link GerichtsGebuehrenTabelle} zu beherbergen.
 *
 * @author Peter Schuster (setrok)
 * @date 23.06.2019
 *
 */
public final class GebuehrenGesetzesSammlung {

//	public static final AnwaltsGebuehrenTabelle RVG = new AnwaltsGebuehrenTabelle();
	private static AnwaltsGebuehrenTabelle RVG = null;

//	public static final GerichtsGebuehrenTabelle GKG = new GerichtsGebuehrenTabelle();
	private static GerichtsGebuehrenTabelle GKG = null;

	/**
	 * @return gibt {@link #rvg} als {@link AnwaltsGebuehrenTabelle} zurück.
	 */
	public static AnwaltsGebuehrenTabelle getRvg() {
		if (RVG == null) {
			RVG = new AnwaltsGebuehrenTabelle();
			Kostenrechner.getLogger().info((String.format("Einlesen von rvg.xml dauerte %d ms.",
					(AnwaltsGebuehrenTabelle.end - AnwaltsGebuehrenTabelle.start))));
		}
		//throw new NullPointerException("Das haste davon");
		return RVG;
	}

	/**
	 * @return gibt {@link #gkg} als {@link GerichtsGebuehrenTabelle} zurück.
	 */
	public static GerichtsGebuehrenTabelle getGkg() {
		if (GKG == null) {
			GKG = new GerichtsGebuehrenTabelle();
			Kostenrechner.getLogger().info((String.format("Einlesen von gkg.xml dauerte %d ms.",
					(GerichtsGebuehrenTabelle.end - GerichtsGebuehrenTabelle.start))));
		}
		return GKG;
	}

}
