/**
 * GerichtsGebuehrenTabelle.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.gebuehren;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;

import javax.xml.bind.JAXB;

/**
 * Das ist eine Klasse, um Gebührenhöhe und -sätze nach dem GKG zu berechnen und
 * zu speichern (also Gerichtsgebühren).
 * 
 * § 34 GKG Wertgebühren (1) Wenn sich die Gebühren nach dem Streitwert richten,
 * beträgt die Gebühr bei einem Streitwert bis 500 Euro 35 Euro. Die Gebühr
 * erhöht sich bei einem
 * 
 * Streitwert bis ... Euro, für jeden angefangenen Betrag von weiteren ... Euro,
 * um ... Euro
 * 
 * 2000, 500, 18
 * 
 * 10000, 1000, 19
 * 
 * 25000, 3000, 26
 * 
 * 50000, 5000, 35
 * 
 * 200000, 15000, 120
 * 
 * 500000, 30000, 179
 * 
 * über 500000, 50000, 180 .
 * 
 * (2) Der Mindestbetrag einer Gebühr ist 15 Euro.
 * 
 * 
 * @author Peter Schuster (setrok)
 * @date 12.01.2014
 * 
 */
public class GerichtsGebuehrenTabelle extends GebuehrenTabelle {

	public static final String GESETZ = "Gerichtskostengesetz (GKG)";
	public static long start;
	public static long end;

	/**
	 * Der Konstruktor ruft den Konstruktor der Oberklasse mit einem grundSprung 500
	 * EUR und einer grundHoehe von 35 EUR auf. Ein Gültigkeitszeitraum wird nicht
	 * festgelegt. Zudem initialisiert er mittels
	 * {@link eu.gronos.kostenrechner.model.gebuehren.AnwaltsGebuehrenTabelle#fuelleTabelle()}
	 * die Gebührentabelle.
	 * 
	 * @see eu.gronos.kostenrechner.model.gebuehren.GebuehrenTabelle#GebuehrenTabelle(long,long,Calendar,Calendar)
	 */
	public GerichtsGebuehrenTabelle() {
		super();
		start = System.currentTimeMillis();
		// war resources/gkg.xml einlesen
		InputStream stream = getClass().getClassLoader().getResourceAsStream("resources/gkg.xml");
		GebuehrenTabelle tab = super.readFromStream(stream);
		setTabelle(tab.getTabelle());
//		setTabelle(readTabelleFromStream(stream));
		setVerzeichnis(tab.getVerzeichnis());
//		setVerzeichnis(new KostenVerzeichnis());
		// super(new GebuehrenTabelle(500L, 35L, null, null));
		// fuelleTabelle();
		// setTabelle(fuelleTabelle());
		end = System.currentTimeMillis();	
	}

	/**
	 * Der Konstruktor ruft den Konstruktor der Oberklasse auf. Zudem initialisiert
	 * er mittels {@link GebuehrenTabelle#readTabelleFromStream(InputStream)} und
	 * {@link #setTabelle(ArrayList)} mittels XML-Datei und {@link JAXB} die Werte
	 * der Tabelle.
	 * 
	 * @param stream ein {@link InputStream} von einer XML-Datei für {@link JAXB}
	 */
	public GerichtsGebuehrenTabelle(InputStream stream) {
		super();
		GebuehrenTabelle tab = super.readFromStream(stream);
		setTabelle(tab.getTabelle());
		setVerzeichnis(tab.getVerzeichnis());
//		setTabelle(readTabelleFromStream(stream));
//		setVerzeichnis(new KostenVerzeichnis());
	}

	/*
	 * Füllt die {@link GebuehrenTabelle#getTabelle() tabelle} der Oberklasse mit
	 * allen nötigen Werten. Wird vom Konstruktor aufgerufen.
	 * 
	 * @return die gefüllte {@link ArrayList}&lt;{@link GebuehrenZeile}&gt;
	 * 
	 * @see eu.gronos.kostenrechner.GebuehrenTabelle#fuelleTabelle()
	 */
	// @Override
	// private ArrayList<GebuehrenZeile> fuelleTabelle() {
	// ArrayList<GebuehrenZeile> gkg = new ArrayList<GebuehrenZeile>();
	// gkg.add(new GebuehrenGrundZeile(500L, 35L, new GregorianCalendar(2013,
	// Calendar.AUGUST, 1), null, GESETZ));
	// gkg.add(new GebuehrenZeile(2000, 500, 18));
	// gkg.add(new GebuehrenZeile(10000, 1000, 19));
	// gkg.add(new GebuehrenZeile(25000, 3000, 26));
	// gkg.add(new GebuehrenZeile(50000, 5000, 35));
	// gkg.add(new GebuehrenZeile(200000, 15000, 120));
	// gkg.add(new GebuehrenZeile(500000, 30000, 179));
	// // § 39 Abs. 2 GKG: Höchstes 30.000.000 EUR
	// gkg.add(new GebuehrenZeile(30000000, 50000, 180));
	// return gkg;
	// }

	// super.gebuehrenTabelle =
	// protected ArrayList<GebuehrenZeile> fuelleTabelle() {
	// ArrayList<GebuehrenZeile> gkg;
	// gkg = new ArrayList<GebuehrenZeile>();
	// return gkg;
}
