/*
 * Teilklageruecknahme.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.gebuehren;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;

/**
 * {@link UnterContainerKlasse} von {@link VerfahrensDatenContainer} für die Registerkarte
 * Teilklagerücknahme (Quotenmethode, Mehrkostenmethode)
 *
 * @author Peter Schuster (setrok)
 * @date 27.12.2014
 *
 */
public class Teilklageruecknahme implements UnterContainerKlasse {
	@XmlElement(name = "partei")
	@XmlElementWrapper(name = "parteien")
	public List<Beteiligter> parteien = new ArrayList<Beteiligter>();

	@XmlElement(name = "wert")
	@XmlElementWrapper(name = "streitwerteUndObsiegen")
	public List<Long> streitwerteUndObsiegen = new ArrayList<Long>();

	@XmlElements({ @XmlElement(name = "anrechnung", type = GebuehrenAnrechnungsTatbestand.class),
			@XmlElement(name = "wertrahmen", type = GebuehrenRahmenTatbestand.class),
			@XmlElement(name = "gebuehrenSatz", type = GebuehrenSatzTatbestand.class),
			@XmlElement(name = "mehrpauschale", type = MehrfachPauschalTatbestand.class),
			@XmlElement(name = "auslagen", type = AuslagenTatbestand.class),
			@XmlElement(name = "pauschale", type = PauschalTatbestand.class),
			@XmlElement(name = "steuer", type = MehrwertsteuerTatbestand.class),
			@XmlElement(name = "erhoehungsSatz", type = GebuehrenErhoehungsTatbestand.class) })
	@XmlElementWrapper(name = "gebuehrenVorRuecknahme")
	// public GebuehrenTatbestand[] vorher = new
	// GebuehrenTatbestand[0];List<GebuehrenTatbestand>
	public GebuehrenVerzeichnis vorher = new GebuehrenVerzeichnis();// ArrayList<GebuehrenTatbestand>();

	@XmlElements({ @XmlElement(name = "anrechnung", type = GebuehrenAnrechnungsTatbestand.class),
			@XmlElement(name = "wertrahmen", type = GebuehrenRahmenTatbestand.class),
			@XmlElement(name = "gebuehrenSatz", type = GebuehrenSatzTatbestand.class),
			@XmlElement(name = "mehrpauschale", type = MehrfachPauschalTatbestand.class),
			@XmlElement(name = "auslagen", type = AuslagenTatbestand.class),
			@XmlElement(name = "pauschale", type = PauschalTatbestand.class),
			@XmlElement(name = "steuer", type = MehrwertsteuerTatbestand.class),
			@XmlElement(name = "erhoehungsSatz", type = GebuehrenErhoehungsTatbestand.class) })
	@XmlElementWrapper(name = "gebuehrenNachRuecknahme")
	// public GebuehrenTatbestand[] nachher = new
	// GebuehrenTatbestand[0];List<GebuehrenTatbestand>
	public GebuehrenVerzeichnis nachher = new GebuehrenVerzeichnis();// ArrayList<GebuehrenTatbestand>();
}