/*
 * BegruendungsElemente.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

import eu.gronos.kostenrechner.interfaces.EntscheidungsElemente;
import eu.gronos.kostenrechner.interfaces.Tabulierend;

/**
 * {@link EntscheidungsElemente} für {@link TenorDatenContainer} mit den Daten
 * für {@link Tabulierend}.
 * 
 * {@link Tabulierend} sieht hier Object[][] tableCellValues vor, der von
 * Class<?>[] columnClasses und String[] columnHeaders erklärt wird. Das lässt
 * sich wohl auf XML schlecht übertragen...
 * 
 * Aber es gibt eine begrenzte Anzahl möglicher Klassen, aus denen die
 * Begründung zusammen gesetzt sein kann, nämlich String für die
 * Zeilen-/Spalten-Überschriften und Double für die Inhalte.
 */
public class BegruendungsElemente implements EntscheidungsElemente {
	@XmlElement(name = "begruendungText")
	public String text;

	// @XmlElement(name = "caret")
	// @XmlElementWrapper(name = "range")
	// public int[] range = new int[2];
	@XmlElement(name = "subString")
	public CaretRange range;

	@XmlElement(name = "spaltenUeberschrift")
	@XmlElementWrapper(name = "spaltenUeberschriften")
	public List<String> columnHeaders;

	@XmlElement(name = "zeilenUeberschrift")
	@XmlElementWrapper(name = "zeilenUeberschriften")
	public List<String> rowHeaders;

	@XmlElementWrapper(name = "zeilen")
	@XmlElement(name = "zeile")
	public List<DoubleDataRows> doubleData;
}