/*
 * CaretRange.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import javax.swing.JEditorPane;
import javax.swing.text.Caret;
import javax.xml.bind.annotation.XmlAttribute;

/**
 * Die Klasse speichert Beginn und Ende der Begründungstabelle 
 * im Begründungstext des {@link TenorDatenContainer}s, also den Bereich als
 * {@link JEditorPane#getCaret()}- / {@link Caret}-Positionen im
 * Begründungstext, den die Tabelle ersetzen soll.
 * 
 * @author Peter Schuster (setrok)
 * @date 18.01.2020
 *
 */
public class CaretRange {

	/**
	 * beginn speichert die Positiion (caret) des Beginn der Begründungstabelle im
	 * Begründungstext als {@link Integer}. Bei {@link String#substring(int, int)}
	 * muss jedoch 1 hinzugerechnet werden.
	 * 
	 */
	@XmlAttribute(name = "beginIndex")
	public Integer beginn = null;

	/**
	 * ende speichert die Position (caret) des Endes der Begründungstabelle im
	 * Begründungstext als {@link Integer}. Entspricht dem endIndex bei
	 * {@link String#substring(int, int)}.
	 */
	@XmlAttribute(name = "endIndex")
	public Integer ende = null;

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (!(obj instanceof CaretRange)) {
			return false;
		}
		CaretRange other = (CaretRange) obj;
		if (beginn == null) {
			if (other.beginn != null) {
				return false;
			}
		} else if (!beginn.equals(other.beginn)) {
			return false;
		}
		if (ende == null) {
			if (other.ende != null) {
				return false;
			}
		} else if (!ende.equals(other.ende)) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return String.format("CaretRange [beginn=%s, ende=%s]", beginn, ende);
	}

}
