/**
 * DoubleDataRows.java
 * eu.gronos.kostenrechner.controller (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import java.util.ArrayList;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Von {@link ArrayList} abgeleitete Klasse, die notwendig ist, weil sich in
 * {@link JAXB} keine mehrdimenensionalen Listen ohne eigene Klasse exportieren
 * lassen lassen.
 *
 * @author Peter Schuster (setrok)
 * @date 2 Jan 2019
 *
 */
@XmlRootElement(name = "zeile")
public class DoubleDataRows extends ArrayList<Double> {

	private static final long serialVersionUID = 1356128727610890073L;

	public DoubleDataRows() {
		super();
	}

	public DoubleDataRows(ArrayList<Double> dv) {
		super(dv.size());
		super.addAll(dv);
	}

	public DoubleDataRows(int size) {
		super(size);
	}

	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		for (Double d : this) {
			buffer.append(String.format("%,.2f ", d));
		}
		return buffer.toString();
	}

	@XmlAttribute(name = "spalten")
	public String getZeile() {
		return toString();
	}

}
