/*
 * HauptsacheEntscheidungsElemente.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

import eu.gronos.kostenrechner.interfaces.EntscheidungsElemente;

/**
 * {@link EntscheidungsElemente} für die Hauptsache im
 * {@link TenorDatenContainer}
 *
 * @author Peter Schuster (setrok)
 * @date 14.02.2020
 *
 */
public class HauptsacheEntscheidungsElemente implements EntscheidungsElemente {
	@XmlElement(name = "HauptsacheentscheidungsText")
	public String text;

	@XmlElement(name = "hauptsacheVerurteilung")
	@XmlElementWrapper(name = "hauptsacheVerurteilungen")
	public List<HauptsacheVerhaeltnis> prozessverhaeltnisse = new ArrayList<HauptsacheVerhaeltnis>();
}