/**
 * HauptsacheVerhaeltnis.java
 * eu.gronos.kostenrechner.calculation (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import javax.xml.bind.annotation.XmlAttribute;

/**
 * Klasse zum strukturierten Darstellen einer Verurteilung in der Hauptsache.
 * 
 *
 * @author Peter Schuster (setrok)
 * @date 22.07.2018
 *
 */
public class HauptsacheVerhaeltnis extends ProzessVerhaeltnis {
	private long verurteilung;

	/**
	 * Konstruktor ohne Parameter für JAXB
	 * 
	 */
	public HauptsacheVerhaeltnis() {
	}

	/**
	 * Konstruktor mit allen Feldern zur raschen Erstellung
	 * 
	 * @param glaeubiger     {@link #getGlaeubiger()}
	 * @param schuldner      {@link #getSchuldner()}
	 * @param darueberHinaus {@link #isDarueberHinaus()}
	 * @param verurteilung   {@link #getVerurteilung()}
	 */
	public HauptsacheVerhaeltnis(Beteiligter glaeubiger, Beteiligter schuldner, boolean darueberHinaus,
			long verurteilung) {
		super(glaeubiger, schuldner, darueberHinaus);
		this.verurteilung = verurteilung;
	}

	/**
	 * @return gibt {@link #verurteilung} als long zurück. Das ist der Betrag, zu
	 *         dessen Zahlung der Schuldner verurteilt wird.
	 *
	 */
	@XmlAttribute(name = "verurteilung")
	public long getVerurteilung() {
		return verurteilung;
	}

	/**
	 * @param verurteilung d. {@link #verurteilung}, d. gesetzt werden soll als long
	 */
	public void setVerurteilung(long verurteilung) {
		this.verurteilung = verurteilung;
	}

	@Override
	public String toString() {
		return String.format("Verurteilung im Prozessverhältnis %s in der Hauptsache zu %.2f Euro",
				super.toString(), (double) getVerurteilung());
	}

}
