/*
 * KostenGrundEntscheidungsElemente.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

import eu.gronos.kostenrechner.interfaces.EntscheidungsElemente;

/**
 * {@link EntscheidungsElemente} für die Kostenentscheidung im
 * {@link TenorDatenContainer}
 *
 * @author Peter Schuster (setrok)
 * @date 14.02.2020
 *
 */
public class KostenGrundEntscheidungsElemente implements EntscheidungsElemente {
	@XmlElement(name = "kostengrundentscheidungsText")
	public String text;

	@XmlElement(name = "kostenTragung")
	@XmlElementWrapper(name = "kostenTragungsEntscheidungen")
	public List<KostenTragungsVerhaeltnis> prozessverhaeltnisse = new ArrayList<KostenTragungsVerhaeltnis>();
}