/**
 * KostenTragungsVerhaeltnis.java
 * eu.gronos.kostenrechner.calculation (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import javax.xml.bind.annotation.XmlAttribute;

/**
 * Klasse zum strukturierten Darstellen einer Verurteilung in den Kosten.
 *
 * @author Peter Schuster (setrok)
 * @date 27.07.2018
 *
 */
public class KostenTragungsVerhaeltnis extends ProzessVerhaeltnis {
	/**
	 * kostenAnteil speichert Bruchteil der Kostentragung (zwischen 0.0 und 1.0) als
	 * double.
	 */
	private double kostenBruchteil;

	/**
	 * Konstruktor ohne Parameter.
	 * 
	 */
	public KostenTragungsVerhaeltnis() {
		super();
	}

	/**
	 * Konstruktor mit allen Feldern zur raschen Erstellung
	 * 
	 * @param glaeubiger      {@link #getGlaeubiger()}
	 * @param schuldner       {@link #getSchuldner()}
	 * @param darueberHinaus  {@link #isDarueberHinaus()}
	 * @param kostenBruchteil {@link #getKostenBruchteil()}
	 */
	public KostenTragungsVerhaeltnis(Beteiligter glaeubiger, Beteiligter schuldner, boolean darueberHinaus,
			double kostenBruchteil) {
		super(glaeubiger, schuldner, darueberHinaus);
		this.kostenBruchteil = kostenBruchteil;
	}

	/**
	 * @return gibt {@link #kostenBruchteil} als double zwischen 0.0 und 1.0 zurück.
	 */
	@XmlAttribute(name = "kostenBruchteil")
	public double getKostenBruchteil() {
		return kostenBruchteil;
	}

	/**
	 * @param kostenBruchteil d. {@link #kostenBruchteil}, d. gesetzt werden soll
	 *                        als double zwischen 0.0 und 1.0
	 */
	public void setKostenBruchteil(double kostenBruchteil) {
		this.kostenBruchteil = kostenBruchteil;
	}

	@Override
	public String toString() {
		return String.format("Kostentragungsverhältnis %s auf Kosten zu %.2f Prozent", super.toString(),
				getKostenBruchteil() * 100.0);
	}

}
