/*
 * StreitwertEntscheidungsElemente.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

import eu.gronos.kostenrechner.interfaces.EntscheidungsElemente;

/**
 * {@link EntscheidungsElemente} für den Streitwert im
 * {@link TenorDatenContainer}
 *
 * @author Peter Schuster (setrok)
 * @date 14.02.2020
 *
 */
public class StreitwertEntscheidungsElemente implements EntscheidungsElemente {
	@XmlElement(name = "streitwertEntscheidungText")
	public String text;

	@XmlElement(name = "streitwert")
	@XmlElementWrapper(name = "streitwerte")
	public List<Long> streitwerte = new ArrayList<Long>();
}