/**
 * TenorDatenContainer.java
 * eu.gronos.kostenrechner.controller (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import eu.gronos.kostenrechner.interfaces.Tenorierend;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import eu.gronos.kostenrechner.model.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.model.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.model.gebuehren.Teilklageruecknahme;

/**
 * Containerklasse, um alle Entscheidungstexte eines {@link Tenorierend} wie
 * auch dessen strukturierten Berechnungsdaten aufnehmen und für Debug- und
 * Support-Zwecke als XML speichern zu können
 * 
 * @author Peter Schuster (setrok)
 * @date 02.07.2018
 *
 */
@XmlRootElement(name = "SchustersStrukturierteTenordaten", namespace = "https://www.kostentenor.de/SchustersStrukturierteTenordaten")
public class TenorDatenContainer extends VerfahrensDatenContainer {

	@XmlElement
	public String berechnungsTyp;

//	@XmlElement(name = "programminfo")
//	public Dateikopf dateikopf = new Dateikopf();

	@XmlElement(name = "hauptsache")
	public HauptsacheEntscheidungsElemente hauptsacheEntscheidung;
	// = new HauptsacheEntscheidungsElemente();

	@XmlElement(name = "kosten")
	public KostenGrundEntscheidungsElemente kostenEntscheidung;
	// = new KostenGrundEntscheidungsElemente();

	@XmlElement(name = "vorlaeufigVollstreckbar")
	public VollstreckbarkeitsEntscheidungsElemente vollstreckbarkeitsEntscheidung;
	// = new VollstreckbarkeitsEntscheidungsElemente();

	@XmlElement(name = "streitwertEntscheidung")
	public StreitwertEntscheidungsElemente streitwertEntscheidung;
	// = new StreitwertEntscheidungsElemente();

	@XmlElement(name = "sonstiges")
	public SonstigeEntscheidungsElemente sonstigeEntscheidung;
	// = new SonstigeEntscheidungsElemente();

	@XmlElement(name = "begruendung")
	public BegruendungsElemente begruendung;
	// = new BegruendungsElemente();

	/**
	 * Standard-Konstruktor ohne Parameter, für {@link JAXB}
	 * 
	 */
	public TenorDatenContainer() {
		super();
		dateikopf = new Dateikopf();
		hauptsacheEntscheidung = new HauptsacheEntscheidungsElemente();
		kostenEntscheidung = new KostenGrundEntscheidungsElemente();
		vollstreckbarkeitsEntscheidung = new VollstreckbarkeitsEntscheidungsElemente();
		streitwertEntscheidung = new StreitwertEntscheidungsElemente();
		sonstigeEntscheidung = new SonstigeEntscheidungsElemente();
		begruendung = new BegruendungsElemente();
	}

	/**
	 * Konstruktor, der einen vollständigen {@link VerfahrensDatenContainer}
	 * erweitert.
	 * 
	 * @param container ein {@link VerfahrensDatenContainer}
	 */
	public TenorDatenContainer(VerfahrensDatenContainer container) {
		this();
		this.allgemein = container.allgemein;
		this.teilklageruecknahme = container.teilklageruecknahme;
		this.streitgenossen = container.streitgenossen;
		this.staffelung = container.staffelung;
		this.gebuehrenBerechnung = container.gebuehrenBerechnung;
	}

	/**
	 * Konstruktor, der die {@link UnterContainerKlasse}n eines
	 * {@link VerfahrensDatenContainer} übernimmt.
	 * 
	 * @param unters mehrere {@link UnterContainerKlasse}n
	 */
	public TenorDatenContainer(UnterContainerKlasse... unters) {
		this();
		for (UnterContainerKlasse unter : unters) {
			if (unter instanceof Allgemein)
				this.allgemein = (Allgemein) unter;
			else if (unter instanceof Teilklageruecknahme)
				this.teilklageruecknahme = (Teilklageruecknahme) unter;
			else if (unter instanceof Streitgenossen)
				this.streitgenossen = (Streitgenossen) unter;
			else if (unter instanceof ForderungsStaffelung)
				this.staffelung = (ForderungsStaffelung) unter;
			else if (unter instanceof GebuehrenBerechnung)
				this.gebuehrenBerechnung = (GebuehrenBerechnung) unter;
		}
	}
}
