/**
 * KostenTenorContainer.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import eu.gronos.kostenrechner.model.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.model.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.model.gebuehren.Teilklageruecknahme;

/**
 * Containerklasse, um alle Zustände im XML-Format speichern zu können.
 *
 * @author Peter Schuster (setrok)
 * @date 26.12.2014
 *
 */
@XmlRootElement(name = "SchustersKleinerKostenTenorXML", namespace = "http://www.kostentenor.de/")
public class VerfahrensDatenContainer {

	@XmlElement(name = "programminfo")
	public Dateikopf dateikopf = new Dateikopf();

	@XmlElement(name = "allgemein")
	public Allgemein allgemein = new Allgemein();

	@XmlElement(name = "teilklageruecknahme")
	public Teilklageruecknahme teilklageruecknahme = new Teilklageruecknahme();

	@XmlElement(name = "streitgenossen")
	public Streitgenossen streitgenossen = new Streitgenossen();

	@XmlElement(name = "forderungsstaffelung")
	public ForderungsStaffelung staffelung = new ForderungsStaffelung();

	@XmlElement(name = "gebuehrenberechnung")
	public GebuehrenBerechnung gebuehrenBerechnung = new GebuehrenBerechnung();

}
