/*
 * VollstreckbarkeitsEntscheidungsElemente.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.tenordaten;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

import eu.gronos.kostenrechner.interfaces.EntscheidungsElemente;

/**
 * {@link EntscheidungsElemente} zur Vollstreckbarkeit im
 * {@link TenorDatenContainer}
 *
 * @author Peter Schuster (setrok)
 * @date 14.02.2020
 *
 */
public class VollstreckbarkeitsEntscheidungsElemente implements EntscheidungsElemente {
	@XmlElement(name = "vollstreckbarkeitsEntscheidungsText")
	public String text;

	@XmlElement(name = "vollstreckungsVerhaeltnis")
	@XmlElementWrapper(name = "vollstreckungsVerhaeltnisse")
	public List<VollstreckungsVerhaeltnis> prozessverhaeltnisse = new ArrayList<VollstreckungsVerhaeltnis>();
}