package eu.gronos.kostenrechner.view;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

import eu.gronos.kostenrechner.model.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;

/**
 * Ein Renderer, der Doubles als Euro-Beträge anzeigen soll.
 */
public class EuroRenderer extends KostenTableRenderer implements TableCellRenderer {
//,		ListCellRenderer<Double> 

	private static final long serialVersionUID = -855994687899724408L;

	/**
	 * Returns the component used for drawing the cell. This method is used to
	 * configure the renderer appropriately before drawing.
	 *
	 * @param table      the <code>JTable</code> that is asking the renderer to
	 *                   draw; can be <code>null</code>
	 * @param value      the value of the cell to be rendered. It is up to the
	 *                   specific renderer to interpret and draw the value. For
	 *                   example, if <code>value</code> is the string "true", it
	 *                   could be rendered as a string or it could be rendered as a
	 *                   check box that is checked. <code>null</code> is a valid
	 *                   value
	 * @param isSelected true if the cell is to be rendered with the selection
	 *                   highlighted; otherwise false
	 * @param hasFocus   if true, render cell appropriately. For example, put a
	 *                   special border on the cell, if the cell can be edited,
	 *                   render in the color used to indicate editing
	 * @param row        the row index of the cell being drawn. When drawing the
	 *                   header, the value of <code>row</code> is -1
	 * @param column     the column index of the cell being drawn
	 * @return ein {@link JLabel}
	 * 
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable,
	 *      java.lang.Object, boolean, boolean, int, int)
	 */
	@Override
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus,
			int row, int column) {
		if (isGesamtschuldnerStreitwert(table, row, column)) {
			setText(BeteiligtenTableModel.GESAMTSCHULDNERISCH);
		} else {
			if (value != null)
				if (value instanceof Double)
					setText(String.format("%,.2f EUR", value));
				else if (value instanceof Long) {
					// FIXME Test für Longs
					final long longValue = ((Long) value).longValue();
					setText(String.format("%,.2f EUR", (double) longValue));
				} else
					setText(value.toString());
			else
				setText("");
		}
		setHorizontalAlignment(SwingConstants.RIGHT);
		setSelected(isSelected);
		if (table.isPaintingForPrint()) {
			setText(getText() + "\t ");
		}
		return this;
	}

	/**
	 * Die Methode findet heraus, ob der {@link TableCellRenderer} gerade den (zu
	 * unterdrückenden) Streitwert einer {@link BaumbachGesamtschuldnerschaft}
	 * darstellen soll.
	 * 
	 * @param table  the <code>JTable</code> that is asking the renderer to draw;
	 *               can be <code>null</code>
	 * @param row    the row index of the cell being drawn. When drawing the header,
	 *               the value of <code>row</code> is -1
	 * @param column the column index of the cell being drawn
	 * @return TODO (kommentieren)
	 */
	private boolean isGesamtschuldnerStreitwert(JTable table, int row, int column) {
		return table.getModel() instanceof BeteiligtenTableModel
				&& table.getModel().getValueAt(row, 0) instanceof BaumbachGesamtschuldnerschaft
				&& column == BeteiligtenTableModel.COLUMN_STREITWERT;
	}
}
// int width = getMinimumSize().width;
// if (width < table.getTableHeader().getColumnModel().getColumn(column)
// .getMinWidth())
// width = table.getTableHeader().getColumnModel().getColumn(column)
// .getMinWidth();
// table.getColumnModel().getColumn(column).setPreferredWidth(width);

//if (isSelected) {
//	/*
//	 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend gesetzt werden.
//	 */
//	setBackground(table.getSelectionBackground());
//	setForeground(table.getSelectionForeground());
//	setOpaque(true);
//} else {/* sonst nicht */
//	setBackground(table.getBackground());
//	setForeground(table.getForeground());
//}
//@Override
//public Component getListCellRendererComponent(JList<? extends Double> list,
//		Double value, int index, boolean isSelected, boolean cellHasFocus) {
//	setText(String.format("%,.2f EUR", value));
//	if (isSelected) {
//		/*
//		 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend
//		 * gesetzt werden.
//		 */
//		setBackground(list.getSelectionBackground());
//		setForeground(list.getSelectionForeground());
//		setOpaque(true);
//	} else {/* sonst nicht */
//		setBackground(list.getBackground());
//		setForeground(list.getForeground());
//	}
//	return this;
//}