/*
 * Farbwelt.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view;

import java.awt.Color;

import javax.swing.UIDefaults;
import javax.swing.UIManager;

/**
 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend gesetzt werden.
 * Die Farbwelt speichert {@link #foreground}, {@link #background},
 * {@link #selectionBackground} und {@link #selectionForeground}, jeweils als
 * {@link Color}
 *
 * @author Peter Schuster (setrok)
 * @date 19.07.2019
 *
 */
public class Farbwelt {
	// private final String gruppe;// = "List";
	public Color foreground;
	public Color background;
	public Color selectionForeground;
	public Color selectionBackground;

	/**
	 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend gesetzt werden.
	 * 
	 * @param gruppe "List" oder "Table", wie bei
	 *               {@link UIDefaults#getColor(Object)}
	 * 
	 */
	public Farbwelt(String gruppe) {
		UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
		foreground = uid.getColor(gruppe + ".foreground");
		background = uid.getColor(gruppe + ".background");
		selectionForeground = uid.getColor(gruppe + ".selectionForeground");
		selectionBackground = uid.getColor(gruppe + ".selectionBackground");
	}


}
