/**
 * GitterBeutelBeschraenkungen.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view;

import java.awt.GridBagConstraints;
import java.awt.Insets;

/**
 * Eine von GridBagConstraints abgeleitete Klasse mit anderen Standardwerten,
 * namentlich fill = BOTH.
 * 
 * The GridBagConstraints class specifies constraints for components that are
 * laid out using the GridBagLayout class. Creates a GridBagConstraint object
 * with all of its fields set to their default value.
 * 
 * @author Peter Schuster (setrok)
 * @date 17.05.2014
 * 
 */
public class GitterBeutelBeschraenkungen extends GridBagConstraints {

	private static final long serialVersionUID = 3590384380736224154L;

	private static GitterBeutelBeschraenkungen instance = null;
	private static final Insets WENIG_RAND = new Insets(1, 2, 1, 2);
	private static final Insets VIEL_RAND = new Insets(4, 4, 4, 4);

	/**
	 * Privater Konstruktor, wird nur intern aufgerufen.
	 * 
	 * @see #getInstance(int, int, int, int, boolean, boolean)
	 * 
	 */
	private GitterBeutelBeschraenkungen(int gridx, int gridy, int gridwidth,
			int gridheight, boolean auchYdehnbar, boolean vielRand) {
		super();
		// TODO nur HORIZONTAL, falls !auchYdehnbar (?)
		super.fill = auchYdehnbar ? GridBagConstraints.BOTH
				: GridBagConstraints.HORIZONTAL;
		super.anchor = GridBagConstraints.CENTER;
		super.insets = vielRand ? VIEL_RAND : WENIG_RAND;
		super.gridx = gridx;
		super.gridy = gridy;
		super.weightx = 0.1;
		super.weighty = auchYdehnbar ? 0.1 : 0;
		super.gridwidth = gridwidth;
		super.gridheight = gridheight;
	}

	/**
	 * Passt die GridBagConstraints in der übergegenen Objektvariable gemäß den
	 * Parametern an.
	 * 
	 * @param gridx
	 *            specifies the cell containing the leading edge of the
	 *            component's display area, where the first cell in a row has
	 *            gridx=0. The leading edge of a component's display area is its
	 *            left edge for a horizontal, left-to-right container and its
	 *            right edge for a horizontal, right-to-left container. The
	 *            value RELATIVE specifies that the component be placed
	 *            immediately following the component that was added to the
	 *            container just before this component was added.
	 * @param gridy
	 *            specifies the cell at the top of the component's display area,
	 *            where the topmost cell has gridy=0. The value RELATIVE
	 *            specifies that the component be placed just below the
	 *            component that was added to the container just before this
	 *            component was added.
	 * @param gridwidth
	 *            Specifies the number of cells in a row for the component's
	 *            display area. Use REMAINDER to specify that the component's
	 *            display area will be from gridx to the last cell in the row.
	 *            Use RELATIVE to specify that the component's display area will
	 *            be from gridx to the next to the last one in its row.
	 *            gridwidth should be non-negative and the default value is 1.
	 * @param gridheight
	 *            Specifies the number of cells in a column for the component's
	 *            display area. Use REMAINDER to specify that the component's
	 *            display area will be from gridy to the last cell in the
	 *            column. Use RELATIVE to specify that the component's display
	 *            area will be from gridy to the next to the last one in its
	 *            column. gridheight should be a non-negative value and the
	 *            default value is 1.
	 * @param auchYdehnbar
	 *            weightx specifies how to distribute extra horizontal space
	 *            (immer 0.1; dehnt also horizontal wie Platz ist); weighty
	 *            specifies how to distribute extra vertical space
	 *            (standardmäßig 0 - also keine Dehnung, nur wenn dieser
	 *            Parameter true ist, wird auch in die Höhe gedehnt).
	 * @param vielRand
	 *            Insets specifies the external padding of the component, the
	 *            minimum amount of space between the component and the edges of
	 *            its display area. Bei vielRand = true liefert die Methode
	 *            4,4,4,4, sonst 1,2,1,2.
	 */
//	@Deprecated
//	static GitterBeutelBeschraenkungen getInstance(int gridx, int gridy,
//			int gridwidth, int gridheight, boolean auchYdehnbar,
//			boolean vielRand) {
//		if (instance == null) {
//			instance = new GitterBeutelBeschraenkungen(gridx, gridy,
//					gridheight, gridwidth, auchYdehnbar, vielRand);
//			return instance;
//		}
//		// TODO nur HORIZONTAL, falls !auchYdehnbar (?)
//		instance.fill = auchYdehnbar ? GridBagConstraints.BOTH
//				: GridBagConstraints.HORIZONTAL;
//		instance.anchor = GridBagConstraints.CENTER;
//		instance.insets = vielRand ? VIEL_RAND : WENIG_RAND;
//		instance.gridx = gridx;
//		instance.gridy = gridy;
//		instance.weightx = 0.1;
//		instance.weighty = auchYdehnbar ? 0.1 : 0;
//		instance.gridwidth = gridwidth;
//		instance.gridheight = gridheight;
//		return instance;
//	}

	/**
	 * Passt die GridBagConstraints in der übergegenen Objektvariable gemäß den
	 * Parametern an.
	 * 
	 * @param gridx
	 *            specifies the cell containing the leading edge of the
	 *            component's display area, where the first cell in a row has
	 *            gridx=0. The leading edge of a component's display area is its
	 *            left edge for a horizontal, left-to-right container and its
	 *            right edge for a horizontal, right-to-left container. The
	 *            value RELATIVE specifies that the component be placed
	 *            immediately following the component that was added to the
	 *            container just before this component was added.
	 * @param gridy
	 *            specifies the cell at the top of the component's display area,
	 *            where the topmost cell has gridy=0. The value RELATIVE
	 *            specifies that the component be placed just below the
	 *            component that was added to the container just before this
	 *            component was added.
	 * @param gridwidth
	 *            Specifies the number of cells in a row for the component's
	 *            display area. Use REMAINDER to specify that the component's
	 *            display area will be from gridx to the last cell in the row.
	 *            Use RELATIVE to specify that the component's display area will
	 *            be from gridx to the next to the last one in its row.
	 *            gridwidth should be non-negative and the default value is 1.
	 * @param gridheight
	 *            Specifies the number of cells in a column for the component's
	 *            display area. Use REMAINDER to specify that the component's
	 *            display area will be from gridy to the last cell in the
	 *            column. Use RELATIVE to specify that the component's display
	 *            area will be from gridy to the next to the last one in its
	 *            column. gridheight should be a non-negative value and the
	 *            default value is 1.
	 * @param fill
	 *            setzt weightx, weighty und fill. <code>fill</code> is used
	 *            when the component's display area is larger than the
	 *            component's requested size. It determines whether to resize
	 *            the component, and if so, how. <code>weightx</code> specifies
	 *            how to distribute extra horizontal space; <code>weighty</code>
	 *            specifies how to distribute extra vertical space.
	 *            GridBagConstraints.NONE: in keine Richtung dehnen.
	 *            GridBagConstraints.HORIZONTAL: Dehnung horizontal anpassen
	 *            (X-Achse), aber nicht vertikal (Y-Achse).
	 *            GridBagConstraints.VERTICAL: Dehnung vertikal anpassen (Y),
	 *            aber nicht horizontal (X). GridBagConstraints.BOTH: Dehnung in
	 *            beide Richtungen.
	 * @param vielRand
	 *            Insets specifies the external padding of the component, the
	 *            minimum amount of space between the component and the edges of
	 *            its display area. Bei vielRand = true liefert die Methode
	 *            4,4,4,4, sonst 1,2,1,2.
	 */
	public static GitterBeutelBeschraenkungen getInstance(int gridx, int gridy,
			int gridwidth, int gridheight, int fill, boolean vielRand) {
		if (instance == null) {
			instance = new GitterBeutelBeschraenkungen(gridx, gridy,
					gridheight, gridwidth, fill == GridBagConstraints.BOTH,
					vielRand);
		}
		instance.anchor = GridBagConstraints.CENTER;
		instance.insets = vielRand ? VIEL_RAND : WENIG_RAND;
		instance.gridx = gridx;
		instance.gridy = gridy;
		instance.gridwidth = gridwidth;
		instance.gridheight = gridheight;
		switch (fill) {
		case GridBagConstraints.BOTH:
			instance.fill = fill;
			instance.weightx = 0.1;
			instance.weighty = 0.1;
			break;
		case GridBagConstraints.HORIZONTAL:
			instance.fill = fill;
			instance.weightx = 0.1;
			instance.weighty = 0;
			break;
		case GridBagConstraints.VERTICAL:
			instance.fill = fill;
			instance.weightx = 0;
			instance.weighty = 0.1;
			break;
		case GridBagConstraints.NONE:
		default:
			instance.fill = GridBagConstraints.NONE;
			instance.weightx = 0;
			instance.weighty = 0;
			break;
		}
		return instance;
	}
}
