package eu.gronos.kostenrechner.view;

import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.text.NumberFormatter;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.HinzufuegenOkAction;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;

/**
 * Oberklasse für alle {@link KostenJDialog}e, die Werte zurückliefern sollen.
 * 
 * @author Peter Schuster (setrok)
 * @date: 29.06.2014
 * 
 * @param <E>
 * 
 */
public abstract class HinzufuegenDialog<E> extends KostenJDialog {

	private static final long serialVersionUID = -6595384338088840389L;
	public static final String FEHLER_BT_UNTERLIEGEN_GT_STREITWERT = "Der Beteiligte kann nicht zu mehr verurteilt werden, als von ihm eingeklagt wurde!";
	public static final String FEHLER_WK_STREITWERT = "Bei einer Widerklage muss der Streitwert > 0 sein.";
	public static final String FEHLER_BK_STREITWERT = "Der Streitwert muss über 0 sein.";
	public static final String FEHLER_ZAHLFORMAT_DWBK = "Ungültiges Zahlformat bei der Anzahl der Drittwiderbeklagten";
	public static final String FEHLER_NIX_WIDERKLAEGER_WIDERBEKLAGTER = "Kein widerklagender Beklagter oder kein Widerbeklagter asugewählt!";
	public static final String FEHLER_UNTERLIEGEN_GT_STREITWERT = "Das Unterliegen darf nicht höher als der Streitwert sein! Bei Gesamtschuldnern wird das gesamtschuldnerische Unterliegen mit berücksichtigt.";
	public static final String FEHLER_ZAHLENFORMAT = "Fehler beim Konvertieren des Zahlenformats!";
	public static final String FEHLER_BK_GESAMTSCHULDNERSCHAFT = "Wenn Sie gesamtschuldnerische Verurteilung aktivieren, muss mehr als ein Beklagter markiert sein, die Höhe der Verurteilung > 0 sein, aber maximal so hoch wie der Streitwert sein.";
	public static final String FEHLER_WK_GESAMTSCHULDNERSCHAFT = "Wenn Sie gesamtschuldnerische Verurteilung aktivieren, muss mehr als ein Widerbeklagter markiert sein, die Höhe der Verurteilung > 0 sein, aber maximal so hoch wie der Streitwert sein.";
	public static final String FEHLER_ZAHLENFORMAT_SW = "Falches Zahlformat beim Streitwert!";
	public static final String FEHLER_KLAEGER_NIX_WBK = "Der ausgewählte Kläger ist nicht widerbeklagt.";
	public static final String FEHLER_ZAHLENFORMAT_KL_BK = "Falsches Zahlformat bei Kläger- oder Beklagtenanzahl! ";
	public static final String FEHLER_BEIM_ANLEGEN_KL_BK = "Fehler beim Anlegen der Kläger oder Beklagten! ";
	public static final String FEHLER_AUSLAGENHOEHE_NEGATIV = "Die Auslagenhöhe darf nicht negativ sein!";
	public static final String FEHLER_ANZAHL_NEGATIV = "Die Anzahl darf nicht negativ sein!";
	public static final String FEHLER_ZAHLENFORMAT_WERT = "Falsches Eingabeformat beim Wert! ";
	public static final String FEHLER_BEGRUENDETHEIT_GT_WERT = "Eine Forderung kann nicht erfolgreicher sein als ihr Wert (ne ultra petita)!";
	// " Die Begründetheit der Forderung kann nicht höher als der Wert sein!";

	/**
	 * Der boolean mit dem Namen isOk speichert, ob der JDialog mit OK oder Cancel
	 * verlassen wurde.
	 */
	private boolean ok = false;
	protected NumberFormatter formatter;

	private /* final */ BeschriebeneAktion okAction;

	private JButton okButton;
	private boolean okButtonToBeFocussed = false;

	/**
	 * Erstellt einen modalen {@link JDialog} mit einer buttonPane (OK und
	 * Abbrechen) und einem contentPanel. Dieser muss von der abgeleiteten Klasse in
	 * der Methode {@link #fuelleContentPane()} mit {@link JComponent}s gefüllt
	 * werden, die von {@link #showDialogAndAsk()} aufgerufen wird.
	 * 
	 * @param owner        das {@link Window} ({@link JFrame} oder {@link JDialog})
	 *                     von dem aus der {@link HinzufuegenDialog} angezeigt wird
	 * @param beschriftung eine {@link Beschriftung}, mit dem der anzuzeigende Titel
	 *                     {@link JDialog#getTitle()} gesetzt wird
	 * @throws HeadlessException wenn in einer Umgebung aufgerufen, die keinen
	 *                           Bildschirm, Tastatur oder Maus unterstützt
	 */
	public HinzufuegenDialog(Window owner, Beschriftung beschriftung) throws HeadlessException {
		super(owner, beschriftung);
		formatter = createNumberFormatter();
	}
	// JFrame

	/**
	 * Die Methode wird von {@link #okAction} aufgerufen, um zu prüfen, ob alle
	 * JComponents zur Eingabe mit gültigen Werten gefüllt sind und diese zueinander
	 * nicht im Widerspruch stehen.
	 * 
	 * @return true, wenn die Plausibilitäten zufrieden sind
	 */
	public abstract boolean parseEingabe();

	/**
	 * Die Methode dient dazu, den Dialog aufzurufen, den {@link #contentPanel} über
	 * die Methode {@link #fuelleContentPane()} der abgeleiteten Klasse mit
	 * Komponenten zu füllen, mit {@link #setBounds()} die Größe des Dialogs
	 * anzupassen und auf eine Eingabe zu warten und dann einen E zurückzugeben.
	 * 
	 * Zur Zurückgabe der Eingabe wird {@link #baueRueckgabewert()} der abgeleiteten
	 * Klasse aufgerufen.
	 * 
	 * @return einen <code>&lt;E&gt;</code> nach den eingegebenen Werten
	 */
	public E showDialogAndAsk() {
		super.showDialog();
		// OK-Schaltfläche fokussieren, wenn gewünscht
		if (isOkButtonToBeFocussed())
			getOkButton().requestFocus();
		// Hier wartet der wohl...
		if (isOk()) {
			return baueRueckgabewert();
		} else {
			return null;
		}
	}

	/**
	 * Die Methode ruft den OK-Button auf
	 * 
	 * @param ae ein ActionEvent
	 */
	public void performOkAction(ActionEvent ae) {
		okAction.actionPerformed(ae);
	}

	/**
	 * Die Methode schließt den Dialog; kann in einer {@link Action} benutzt werden
	 * 
	 */
	@Override
	public void fensterSchliessenBeiAbbruch() {
		setOk(false);
		super.fensterSchliessenBeiAbbruch();
	}

	/**
	 * @return gibt {@link #ok} als {@link boolean} zurück.
	 */
	public boolean isOk() {
		return ok;
	}

	/**
	 * @param ok d. {@link #ok}, d. gesetzt werden soll als {@link boolean}.
	 */
	public void setOk(boolean ok) {
		this.ok = ok;
	}

	/**
	 * @return {@link #okButtonToBeFocussed}, also true, wenn bei Aufruf der Maske
	 *         der OK-Button den Focus haben soll, sonst false.
	 */
	public boolean isOkButtonToBeFocussed() {
		return okButtonToBeFocussed;
	}

	/**
	 * @param okButton d. {@link #okButton}, d. gesetzt werden soll als
	 *                 {@link JButton}.
	 */
	public void setOkButton(JButton okButton) {
		this.okButton = okButton;
	}

	/**
	 * Die Methode dient dazu, aus den Eingabefeldern des Dialogs einen Rückgabewert
	 * zusammenzubauen, der dann von {@link #showDialogAndAsk()} an die aufrufende
	 * Maske zurückgegeben werden kann.
	 * 
	 * @return ein <code>&lt;E&gt;</code> mit allen Werten
	 */
	protected abstract E baueRueckgabewert();

	/**
	 * Die Methode soll die OK-Schaltfläche fokussieren, wenn gewünscht
	 * 
	 * @param okButtonToBeFocussed true, wenn bei Aufruf der Maske der OK-Button den
	 *                             Focus haben soll
	 */
	protected void setOkButtonToBeFocussed(boolean okButtonToBeFocussed) {
		this.okButtonToBeFocussed = okButtonToBeFocussed;
	}

	/**
	 * @return gibt die okAction als AbstractAction zurück.
	 */
	protected AbstractAction getOkAction() {
		return okAction;
	}

	/**
	 * Die Methode aktiviert oder deaktiviert den Ok-Button
	 * 
	 * @param enabled true oder false
	 */
	protected void setOkActionEnabled(boolean enabled) {
		okAction.setEnabled(enabled);
	}

	/**
	 * @return gibt {@link #okButton} als {@link JButton} zurück.
	 */
	protected JButton getOkButton() {
		return okButton;
	}

	/**
	 * Die Methode setzt die Abbrechen-Schaltfläche über
	 * {@link KostenJDialog#setButtonPane()} in einen eigenen JPanel des Dialogs und
	 * fügt auch eine OK-Schaltfläche hinzu
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJDialog#setButtonPane()
	 */
	@Override
	protected void setButtonPane() {
		super.setButtonPane();
		// Der Cancel-Button muss hier "Abbrechen" heißen
		super.changeCancelBeschriftung(0);

		// Der Konstruktor der Oberklasse ruft diese Methode vor dem hiesigen
		// Konstruktor auf, deshalb muss die okAction hier schon gesetzt werden.
		if (okAction == null) {
			createOkAction();
		}
		// Die Oberklasse hat keinen OK-Button
		setOkButton(okAction.toButton());
		addToRootInputMap(okAction);
		getButtonPane().add(getOkButton(), 0);
		getRootPane().setDefaultButton(getOkButton());

	}

	/**
	 * Die Methode baut die {@link #getOkAction()}
	 */
	private void createOkAction() {
		okAction = new HinzufuegenOkAction<E>(this, (LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(76051));
	}

	/**
	 * Die Methode baut einen Numberformatter. Der kann für Nummereingabefelder
	 * benutzt werden. Grouping ist ausgeschaltet, Eingaben können fehlerhaft sein.
	 * 
	 * @return den {@link NumberFormatter}
	 */
	private NumberFormatter createNumberFormatter() {
		NumberFormat format = DecimalFormat.getInstance(Locale.GERMAN);
		// NumberFormat format = NumberFormat.getInstance();
		NumberFormatter formatter = new NumberFormatter(format);
		format.setGroupingUsed(false);
		formatter.setAllowsInvalid(true);
		// formatter.setAllowsInvalid(false);
		return formatter;
	}
}
// , KeyEvent.VK_A,KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0)
//"OK","OK", 
//"Bestätigt die Eingabe (Eingabetaste).", 
//	, "Abbrechen","Cancel", 
//"Bricht die Eingabe ab (ESC).", 

/*
 * Erstellt einen modalen JDialog mit einer buttonPane (OK und Abbrechen) und
 * einem contentPanel. Dieser muss von der abgeleiteten Klasse in der Methode
 * {@link #fuelleContentPane()} mit JComponents gefüllt werden, die von {@link
 * #showDialog()} aufgerufen wird.
 * 
 * @param owner the JFrame from which the dialog is displayed
 * 
 * @param title Der anzuzeigende Titel
 * 
 * @throws HeadlessException wenn in einer Umgebung aufgerufen, die keinen
 * Bildschirm, Tastatur oder Maus unterstützt
 * 
 * @Deprecated besser {@link #HinzufuegenDialog(JFrame, Beschriftung)} nutzen
 */
//@Deprecated
//public HinzufuegenDialog(JFrame owner, String title) throws HeadlessException {
//	super(owner, title, true);
//	baueContentPane();
//	setButtonPane();
//	formatter = createNumberFormatter();
//}

/*
 * Die Methode zieht den Zahlwert aus dem übergebenen {@link
 * JFormattedTextField} (brauchte keiner mehr)
 * 
 * @param formattedTextField das {@link JFormattedTextField}, das ausgelesen
 * werden soll.
 * 
 * @param beschriftung der Text des dazugehörigen {@link JLabel}s
 * 
 * @return den ausgelesenen Wert als double
 * 
 * 
 * protected double doubleAusFormatter(JFormattedTextField formattedTextField,
 * String beschriftung) throws NumberFormatException { return new
 * NumberExtractor(formattedTextField, beschriftung).extractDouble(); }
 */

/*
 * Die Methode zieht den Zahlwert aus dem übergebenen {@link
 * JFormattedTextField} (brauchte keiner mehr)
 * 
 * @param formattedTextField das {@link JFormattedTextField}, das ausgelesen
 * werden soll.
 * 
 * @param beschriftung der Text des dazugehörigen {@link JLabel}s
 * 
 * @return den ausgelesenen Wert als double
 * 
 * 
 * 
 * protected int intAusFormatter(JFormattedTextField formattedTextField, String
 * beschriftung) throws NumberFormatException { return new
 * NumberExtractor(formattedTextField, beschriftung).extractInteger(); }
 */
// rp.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
// KeyStroke.getKeyStroke(
// (Integer) action.getValue(Action.ACCELERATOR_KEY),
// InputEvent.ALT_DOWN_MASK),
// action.getValue(Action.ACTION_COMMAND_KEY));

/*
 * Ordnet ein JLabel einer JComponent zu und setzt den Mnemonic key. (brauchte
 * keiner mehr)
 * 
 * @param label ein JLabel
 * 
 * @param component the Component this label is for, or null if the label is not
 * the label for a component
 * 
 * @param key a keycode that indicates a mnemonic key
 * 
 * @see javax.swing.JLabel#setLabelFor(Component)
 * 
 * @see javax.swing.JLabel#setDisplayedMnemonic(int)
 * 
 * 
 * protected void setMnemonicLabelFor(JLabel label, JComponent component, int
 * key) { label.setLabelFor(component); label.setDisplayedMnemonic(key); }
 */