/*
 * KostenListRenderer.java
 * eu.gronos.kostenrechner.view.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.view;

import java.awt.Component;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

import eu.gronos.kostenrechner.view.helpanderror.FontHelferForComponent;

/**
 * Die abstrakte Oberklasse zum Rendern als zweizeiliges {@link JPanel}
 *
 * @author Peter Schuster (setrok)
 * @date 16.07.2019
 *
 */
public abstract class KostenListRenderer extends JPanel {

	private static final long serialVersionUID = -5602995226227247953L;
//	protected Font normal;
//	protected Font fett;
	protected final FontHelferForComponent helfer = new FontHelferForComponent(this);
	protected final Farbwelt farbwelt = new Farbwelt("List");

	/**
	 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend gesetzt werden.
	 * Sonst nicht.
	 */
	protected void setSelected(boolean isSelected) {
		for (Component component : super.getComponents()) {
			final JLabel label = (JLabel) component;
			setSelected(label, isSelected);
		}
	}

	/**
	 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend gesetzt werden.
	 * Sonst nicht.
	 */
	protected void setSelected(JLabel label, boolean isSelected) {
		if (isSelected) {
			label.setBackground(farbwelt.selectionBackground);
			label.setForeground(farbwelt.selectionForeground);
		} else {
			label.setBackground(farbwelt.background);
			label.setForeground(farbwelt.foreground);
		}
	}

	/**
	 * Die Methode setzt die Deckkraft aller enthaltenen {@link JComponent}s.
	 * 
	 * @param isOpaque true, wenn alle {@link JComponent}s Deckkraft haben sollen.
	 * 
	 * @see javax.swing.JComponent#setOpaque(boolean)
	 */
	protected void setAllOpaque(boolean isOpaque) {
		for (Component component : super.getComponents()) {
			if (component instanceof JComponent) {
				((JComponent) component).setOpaque(isOpaque);
			}
		}
	}

}