/*
 * TabbedPaneFactory.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import eu.gronos.kostenrechner.controller.ComponentBeschrifter;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;

/**
 * Eine Klasse, die Tabs für {@link JTabbedPane} mit {@link Beschriftung}
 * erstellt
 *
 * @author Peter Schuster (setrok)
 * @date 29.08.2019
 *
 */
public class TabbedPaneFactory {

	// private EmptyBorder border = new EmptyBorder(5, 5, 5, 5);

	/**
	 * Die Methode fügt das {@link JPanel} in die {@link JTabbedPane} als neuen Tab
	 * ein.
	 * 
	 * @param pane         {@link JTabbedPane}
	 * @param panel        {@link JPanel}
	 * @param beschriftung {@link Beschriftung}
	 * @throws IllegalArgumentException TODO (kommentieren)
	 */
	public static void intoTabbedPane(JTabbedPane pane, JPanel panel, Beschriftung beschriftung)
			throws IllegalArgumentException {
		pane.addTab(beschriftung.getTitle(), null, panel, beschriftung.getShortDescription());
		int index = pane.getTabCount() - 1;
		pane.setEnabledAt(index, true);
		pane.setMnemonicAt(index, beschriftung.mnemonicIntValue());
		//.applyTo
		new ComponentBeschrifter().beschrifte(panel, beschriftung);
	}
	// Beschriftung.baueHtmlTooltip(beschriftung.getTitle(), )
}