/*
 * BeteiligtenListRenderer.java
 * eu.gronos.kostenrechner.view.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.baumbach;

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;

import eu.gronos.kostenrechner.model.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.view.KostenListRenderer;

/**
 *
 * Ein Renderer für {@link Beteiligter}, für JList und JComboBox
 * 
 * @author Peter Schuster (setrok)
 * @date 16.07.2019
 *
 */
public class BeteiligtenListRenderer extends KostenListRenderer implements ListCellRenderer<Beteiligter> {
	private static final long serialVersionUID = -4580949588130202239L;
	private static final int FONT_MULTIPLIKATOR = 19;
	private final JLabel lbParteiBezeichner;
	private final JLabel lbStreitwert;
	private final JLabel lbUnterliegen;
	// private final JLabel lbAnWiderklageBeteiligt;
	private final boolean laufendeNummerImmerAusblenden;

	public BeteiligtenListRenderer(boolean laufendeNummerImmerAusblenden) {
		super();

		/* JLabels bauen */
		lbParteiBezeichner = new JLabel();
		lbStreitwert = new JLabel();
		lbUnterliegen = new JLabel();
		// lbAnWiderklageBeteiligt = new JLabel();

		helfer.boldLabel(lbParteiBezeichner);

		lbUnterliegen.setHorizontalAlignment(SwingConstants.RIGHT);

		helfer.sizeLabel(lbStreitwert, FONT_MULTIPLIKATOR);

		/* Jetzt endlich das JPanel bauen */
		super.setLayout(new BorderLayout());
		super.add(lbParteiBezeichner, BorderLayout.PAGE_START);
		// super.add(lbAnWiderklageBeteiligt, // BorderLayout.LINE_START);
		super.add(lbStreitwert, BorderLayout.CENTER);
		super.add(lbUnterliegen, BorderLayout.LINE_END);

		setAllOpaque(true);
		this.laufendeNummerImmerAusblenden = laufendeNummerImmerAusblenden;
	}

	public BeteiligtenListRenderer() {
		this(false);
	}

	/**
	 * Die Methode stellt einen Beteiligten in JList und JComboBox dar
	 * 
	 * @param list         list The JList we're painting.
	 * @param value        value The value returned by
	 *                     list.getModel().getElementAt(index).
	 * @param index        index The cells index.
	 * @param isSelected   isSelected True if the specified cell was selected.
	 * @param cellHasFocus cellHasFocus True if the specified cell has the focus.
	 * @return A component whose paint() method will render the specified value.
	 * 
	 * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList,
	 *      java.lang.Object, int, boolean, boolean)
	 */
	@Override
	public Component getListCellRendererComponent(JList<? extends Beteiligter> list, Beteiligter value, int index,
			boolean isSelected, boolean cellHasFocus) {

		boolean einzigerSeinerArt = laufendeNummerImmerAusblenden ? laufendeNummerImmerAusblenden
				: list.getModel().getSize() < 2;

		/*
		 * Da Beteiligter.parteiBezeichner die lfdNr zuweist, muss ich aufpassen, dass
		 * ich sie nicht verändere, wenn sie schon gesetzt wurde. Wenn sie noch nicht
		 * gesetzt wurde, ist sie < 0.
		 */
		lbParteiBezeichner.setText(value.parteiBezeichner(Beteiligter.NOMINATIV, value.getLfdNr(), einzigerSeinerArt));
		setSelected(isSelected);

		if (value instanceof BaumbachBeteiligter) {
			lbStreitwert.setText(
					String.format("Inanspruchnahme: %,.2f EUR", ((BaumbachBeteiligter) value).getStreitwert()));
			lbUnterliegen
					.setText(String.format("Verurteilung: %,.2f EUR", ((BaumbachBeteiligter) value).getUnterliegen()));
			if (((BaumbachBeteiligter) value).isAnWiderklageBeteiligt()) {
				int genusNumerus = value.getGenusNumerus();
				if (genusNumerus > Beteiligter.PLURAL) {
					genusNumerus -= Beteiligter.PLURAL;
				}
				switch (value.getTyp()) {
				case Beteiligter.KLAEGER:
					lbParteiBezeichner.setText(String.format(BaumbachBeteiligter.PARTEI_UND_WK_WBK,
							lbParteiBezeichner.getText(), BaumbachBeteiligter.WIDERBEKLAGTEN_BEUGUNG[genusNumerus]));
					break;
				case Beteiligter.BEKLAGTE:
					lbParteiBezeichner.setText(String.format(BaumbachBeteiligter.PARTEI_UND_WK_WBK,
							lbParteiBezeichner.getText(), BaumbachBeteiligter.WIDERKLAEGER_BEUGUNG[genusNumerus]));
					break;
				default:
					break;
				}
			}
			super.setToolTipText(lbParteiBezeichner.getText());
			return this;
		} else {
			lbParteiBezeichner.setToolTipText(lbParteiBezeichner.getText());
			setSelected(lbParteiBezeichner, isSelected);
			return lbParteiBezeichner;
		}
	}

//	@Override
//	public Component getListCellRendererComponent(
//			JList<? extends Beteiligter> list, Beteiligter value, int index,
//			boolean isSelected, boolean cellHasFocus) {
//		boolean einzigerSeinerArt = laufendeNummerImmerAusblenden ? laufendeNummerImmerAusblenden
//				: list.getModel().getSize() < 2;
//		/*
//		 * Da Beteiligter.parteiBezeichner die lfdNr zuweist, muss ich
//		 * aufpassen, dass ich sie nicht verändere, wenn sie schon gesetzt
//		 * wurde. Wenn sie noch nicht gesetzt wurde, ist sie < 0.
//		 */
//		if (value.getLfdNr() < 0)
//			value.setLfdNr(index + 1);
//		setText(value.parteiBezeichner(Beteiligter.NOMINATIV, value.getLfdNr(),
//				einzigerSeinerArt));
//		if (value instanceof BaumbachGesamtschuldnerschaft) {
//			BaumbachGesamtschuldnerschaft bgs = (BaumbachGesamtschuldnerschaft) value;
//			setToolTipText(bgs.parteiBezeichner(Beteiligter.NOMINATIV,
//					value.getLfdNr(), true));
//		} else if (value instanceof BaumbachBeteiligter
//				|| value instanceof Beteiligter) {
//			setToolTipText(value.parteiBezeichner(Beteiligter.NOMINATIV,
//					value.getLfdNr(), einzigerSeinerArt));
//		}
//		if (isSelected) {
//			setBackground(list.getSelectionBackground());
//			setForeground(list.getSelectionForeground());
//			setOpaque(true);
//		} else {/* sonst nicht */
//			setBackground(list.getBackground());
//			setForeground(list.getForeground());
//		}
//		return this;
//	}

}
