/**
 * WiderklageHinzufuegenDialog.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.baumbach;

import java.awt.GridBagConstraints;
import java.awt.HeadlessException;

import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.gebuehren.WiderklagePruefer;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.baumbach.Widerklage;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.view.GitterBeutelBeschraenkungen;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Ein kleiner HinzufuegenDialog, der auch nach wirtschaftlicher Identität fragt
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class WiderklageHinzufuegenDialog extends HinzufuegenDialog<Widerklage> {
	private static final long serialVersionUID = -9111863513392608271L;
	private JCheckBox chbWiderklage;
	private JCheckBox chbWirtschaftlichIdentisch;
	private ParsendUndBauend<Widerklage> pruefer = new WiderklagePruefer();

	/**
	 * Konstruktor.
	 * 
	 * @param owner ein {@link JFrame}, im Zweifel ein Verweis auf
	 *              {@link Kostenrechner}, wird von {@link JDialog} für modale
	 *              Fenster gebraucht
	 * @param title der {@link String} für den Titel.
	 */
	public WiderklageHinzufuegenDialog(JFrame owner) throws HeadlessException {
		super(owner, (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(37000));
		// , Beschriftung title, "Widerklage aktivieren"
	}

	// "Widerklage aktivieren", true
	// chbWiderklage.setName("chbWiderklage");
	// chbWiderklage.setToolTipText(Beschriftung.baueHtmlTooltip(chbWiderklage.getText(),
	// "Wählen Sie bitte aus, ob eine Widerklage vorhanden ist."));
	// "Widerklage wirtschaftlich identisch",
	// chbWirtschaftlichIdentisch.setName("chbWirtschaftlichIdentisch");
	// chbWirtschaftlichIdentisch.setToolTipText(Beschriftung.baueHtmlTooltip(chbWirtschaftlichIdentisch.getText(),
	// "(§ 45 Abs. 1 Satz 3 GKG)\n"
	// + "Betreffen die Ansprüche im Fall des Satzes 1 oder 2 (Klage und
	// Widerklage,\n"
	// + "hilfsweise geltend gemachte Ansprüche)\n"
	// + "denselben Gegenstand, ist nur der Wert des höheren Anspruchs
	// maßgebend."));

	@Override
	public boolean parseEingabe() {
		return pruefer.leseComponents(chbWiderklage, chbWirtschaftlichIdentisch).parseEingabe();
	}

	/**
	 * Die Methode baut ein {@link Widerklage}-Objekt aus den Werten der beiden
	 * {@link JCheckBox}-Elemente des Dialogs
	 * 
	 * @return ein Objekt {@link Widerklage}
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
	 */
	@Override
	protected Widerklage baueRueckgabewert() {
		final Widerklage rueckgabewert = pruefer.leseComponents(chbWiderklage, chbWirtschaftlichIdentisch)
				.getRueckgabewert();
		return rueckgabewert;
	}

	@Override
	protected void fuelleContentPane() {
		chbWiderklage = (JCheckBox) beschrifter.beschrifte(new JCheckBox(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(37001));
		chbWiderklage.setSelected(true);

		chbWirtschaftlichIdentisch = (JCheckBox) beschrifter.beschrifte(new JCheckBox(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(37011));
		chbWirtschaftlichIdentisch.setSelected(false);

		contentPanel.add(chbWiderklage,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		contentPanel.add(chbWirtschaftlichIdentisch,
				GitterBeutelBeschraenkungen.getInstance(0, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
	}
	// "Widerklage aktivieren", true
	// chbWiderklage.setName("chbWiderklage");
	// chbWiderklage.setToolTipText(Beschriftung.baueHtmlTooltip(chbWiderklage.getText(),
	// "Wählen Sie bitte aus, ob eine Widerklage vorhanden ist."));
	// "Widerklage wirtschaftlich identisch",
	// chbWirtschaftlichIdentisch.setName("chbWirtschaftlichIdentisch");
	// chbWirtschaftlichIdentisch.setToolTipText(Beschriftung.baueHtmlTooltip(chbWirtschaftlichIdentisch.getText(),
	// "(§ 45 Abs. 1 Satz 3 GKG)\n"
	// + "Betreffen die Ansprüche im Fall des Satzes 1 oder 2 (Klage und
	// Widerklage,\n"
	// + "hilfsweise geltend gemachte Ansprüche)\n"
	// + "denselben Gegenstand, ist nur der Wert des höheren Anspruchs
	// maßgebend."));

}