/**
 * ForderungHinzufuegen.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.forderungen;

import java.awt.GridBagConstraints;

import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

import eu.gronos.kostenrechner.controller.forderungen.ForderungPruefer;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.model.forderungen.AufrechnungsForderung;
import eu.gronos.kostenrechner.model.forderungen.Forderung;
import eu.gronos.kostenrechner.model.forderungen.KlageForderung;
import eu.gronos.kostenrechner.view.GitterBeutelBeschraenkungen;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Ein HinzufügenDialog für Forderungen
 *
 * @author Peter Schuster (setrok)
 * @date 03.08.2014
 *
 */
public class ForderungHinzufuegen extends HinzufuegenDialog<Forderung> {

	private static final long serialVersionUID = 7212266450545525463L;

	private JComboBox<Forderung> cmbForderungsart;
	private JFormattedTextField ftfStreitwert;
	private JFormattedTextField ftfUnterliegen;
	private final ParsendUndBauend<Forderung> pruefer = new ForderungPruefer();

	/**
	 * Konstruktor erzeugt den Dialog
	 * 
	 * @param owner der aufrufende JFrame
	 */
	public ForderungHinzufuegen(JFrame owner) {
		super(owner, (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(45000));
	}

	/**
	 * Die Methode gibt ein Array von Forderungen für JComboBox
	 * 
	 * @return ein Array Forderung[] mit einer KlageForderung und einer
	 *         AufrechnungsForderun
	 */
	public static Forderung[] sammleForderungen() {
		return new Forderung[] { new KlageForderung(0, 0), new AufrechnungsForderung(0, 0) };
	}

	/**
	 * Die Methode wird von okAction aufgerufen, um zu prüfen, ob alle JComponents
	 * zur Eingabe mit gültigen Werten gefüllt sind und diese zueinander nicht im
	 * Widerspruch stehen.
	 * 
	 * @return true, wenn sich die Werte in den Feldern Höhe und Begründetheit
	 *         parsen lassen und der Erfolg nicht höher als der Wert ist.
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#parseEingabe()
	 */
	@Override
	public boolean parseEingabe() {
		pruefer.leseComponents(cmbForderungsart, ftfStreitwert, ftfUnterliegen);
		return pruefer.parseEingabe();
	}

	/**
	 * Die Methode füllt das contentPanel mit einer JComboBox, je einem
	 * JFormattedTextField für Streitwert und Erfolg sowie dazugehörigen JLabels.
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#fuelleContentPane()
	 */
	@Override
	protected void fuelleContentPane() {
		JLabel lblForderungsart = (JLabel) beschrifter.beschrifte(new JLabel(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(45011));
		lblForderungsart.setHorizontalAlignment(SwingConstants.RIGHT);

		cmbForderungsart = new JComboBox<Forderung>(sammleForderungen());
		beschrifter.beschrifte(cmbForderungsart, NameContainerSammlung.BESCHRIFTUNGEN.get(45015));
		cmbForderungsart.setRenderer(new ForderungenRenderer());
		lblForderungsart.setLabelFor(cmbForderungsart);

		JLabel lblWert = (JLabel) beschrifter.beschrifte(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(45021));
		ftfStreitwert = (JFormattedTextField) beschrifter.beschrifte(new JFormattedTextField(formatter),
				NameContainerSammlung.BESCHRIFTUNGEN.get(45025));
		ftfStreitwert.setText(Double.toString(0));
		setEnterAction(ftfStreitwert, getOkAction());
		lblWert.setLabelFor(ftfStreitwert);

		JLabel lblErfolg = (JLabel) beschrifter.beschrifte(new JLabel(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(45031));
		ftfUnterliegen = (JFormattedTextField) beschrifter.beschrifte(new JFormattedTextField(formatter),
				NameContainerSammlung.BESCHRIFTUNGEN.get(45035));
		ftfUnterliegen.setText(Double.toString(0));
		setEnterAction(ftfUnterliegen, getOkAction());
		lblErfolg.setLabelFor(ftfUnterliegen);

		contentPanel.add(lblForderungsart,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		contentPanel.add(cmbForderungsart,
				GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		contentPanel.add(lblWert,
				GitterBeutelBeschraenkungen.getInstance(0, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
		contentPanel.add(ftfStreitwert,
				GitterBeutelBeschraenkungen.getInstance(1, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
		contentPanel.add(lblErfolg,
				GitterBeutelBeschraenkungen.getInstance(0, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));
		contentPanel.add(ftfUnterliegen,
				GitterBeutelBeschraenkungen.getInstance(1, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));
	}

	/**
	 * Die Methode dient dazu, aus den Eingabefeldern des Dialogs einen Rückgabewert
	 * zusammenzubauen, der dann von showDialog() an die aufrufende Maske
	 * zurückgegeben werden kann.
	 * 
	 * @return eine Forderung in der gewählten Höhe
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
	 */
	@Override
	protected Forderung baueRueckgabewert() {
		pruefer.leseComponents(cmbForderungsart, ftfStreitwert, ftfUnterliegen);
		return pruefer.getRueckgabewert();
	}
}
// private static final String TITLE = "Neues Angriffs-/Verteidigungsmittel";// TITLE
// public static final String TEXT_ERFOLG = "Davon begründet:";
// public static final String TEXT_STREITWERT = "Höhe der Forderung:";
// public static final String TEXT_FORDERUNGS_ART =
// "Angriffs-/Verteidigungsmittel:";
// TEXT_FORDERUNGS_ART,
// cmbForderungsart.setName("cmbForderungsart");
// setMnemonicLabelFor(, , KeyEvent.VK_V);
// TEXT_STREITWERT, SwingConstants.RIGHT
// lblWert.setToolTipText(Beschriftung.baueHtmlTooltip(TEXT_STREITWERT,
// "Bitte geben Sie hier die Höhe (den Streitwert) der Forderung (Klage oder
// Aufrechnung) an sich an."));
// ftfStreitwert.setName("ftfStreitwert");
// setMnemonicLabelFor(, , KeyEvent.VK_H);
// new JLabel(TEXT_ERFOLG, SwingConstants.RIGHT);
// lblErfolg.setToolTipText(Beschriftung.baueHtmlTooltip(TEXT_ERFOLG,
// "Bitte geben Sie hier an, in welcher Höhe der Forderung durchdringt!"));
// ftfUnterliegen.setName("ftfUnterliegen");
// setMnemonicLabelFor(, , KeyEvent.VK_B);