/**
 * ForderungenRenderer.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.forderungen;

import java.awt.Component;

import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

import eu.gronos.kostenrechner.model.forderungen.Forderung;
import eu.gronos.kostenrechner.view.KostenTableRenderer;

/**
 * Ein Renderer für Forderungen, abgeleitet von JLabel
 *
 * @author Peter Schuster (setrok)
 * @date 02.08.2014
 *
 */
public class ForderungenRenderer extends KostenTableRenderer implements TableCellRenderer,
		ListCellRenderer<Forderung> {

	private static final long serialVersionUID = 8931752344357619689L;

	/**
	 * Creates a JLabel instance with no image and with an empty string for the
	 * title. The label is centered vertically in its display area. The label's
	 * contents, once set, will be displayed on the leading edge of the label's
	 * display area.
	 */
	public ForderungenRenderer() {
		super();
	}

	/**
	 * Gibt eine JComponent zum Darstellen der Forderung zurück, hier ein
	 * JLabel, dass die Forderungsart als String darstellt.
	 * 
	 * Return a component that has been configured to display the specified
	 * value. That component's paint method is then called to "render" the cell.
	 * If it is necessary to compute the dimensions of a list because the list
	 * cells do not have a fixed size, this method is called to generate a
	 * component on which getPreferredSize can be invoked.
	 * 
	 * @param list
	 *            list The JList we're painting.
	 * @param value
	 *            value The value returned by
	 *            list.getModel().getElementAt(index).
	 * @param index
	 *            index The cells index.
	 * @param isSelected
	 *            isSelected True if the specified cell was selected.
	 * @param cellHasFocus
	 *            cellHasFocus True if the specified cell has the focus.
	 * @return A component whose paint() method will render the specified value.
	 * 
	 * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList,
	 *      java.lang.Object, int, boolean, boolean)
	 */
	@Override
	public Component getListCellRendererComponent(
			JList<? extends Forderung> list, Forderung value, int index,
			boolean isSelected, boolean cellHasFocus) {
		setText(value);
		setSelected(isSelected);
		return this;
	}

	/**
	 * Gibt eine JComponent zum Darstellen der Forderung zurück, hier ein
	 * JLabel, dass die Forderungsart als String darstellt.
	 * 
	 * Returns the component used for drawing the cell. This method is used to
	 * configure the renderer appropriately before drawing.
	 * 
	 * @param table
	 *            the <code>JTable</code> that is asking the renderer to draw;
	 *            can be <code>null</code>
	 * @param value
	 *            the value of the cell to be rendered. It is up to the specific
	 *            renderer to interpret and draw the value. For example, if
	 *            <code>value</code> is the string "true", it could be rendered
	 *            as a string or it could be rendered as a check box that is
	 *            checked. <code>null</code> is a valid value
	 * @param isSelected
	 *            true if the cell is to be rendered with the selection
	 *            highlighted; otherwise false
	 * @param hasFocus
	 *            if true, render cell appropriately. For example, put a special
	 *            border on the cell, if the cell can be edited, render in the
	 *            color used to indicate editing
	 * @param row
	 *            the row index of the cell being drawn. When drawing the
	 *            header, the value of <code>row</code> is -1
	 * @param column
	 *            the column index of the cell being drawn
	 * @return the component used for drawing the cell. This method is used to
	 *         configure the renderer appropriately before drawing.
	 * 
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable,
	 *      java.lang.Object, boolean, boolean, int, int)
	 */
	@Override
	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		setText(value);
		setSelected(isSelected);
		return this;
	}

	/**
	 * Die Methode setzt den Labeltext nach der Beschreibung der Forderung
	 * 
	 * @param value
	 *            den Zellinhalt als Object
	 */
	private void setText(Object value) {
		if (value instanceof Forderung) {
			final Forderung f = (Forderung) value;
			super.setText(f.getBeschreibung());
			setToolTipText(f.toString());
		} else if (value != null)
			super.setText(value.toString());
		else
			super.setText("(leer)");
	}

//	if (isSelected) {
//		/*
//		 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend dem
//		 * selectionBackground und selectionForeground gesetzt werden.
//		 */
//		setBackground(table.getSelectionBackground());
//		setForeground(table.getSelectionForeground());
//		setOpaque(true);
//	} else {/* sonst entsprechend dem background und foreground der table */
//		faerbeNormal(table);
//	}
//	if (isSelected) {
//		/*
//		 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend dem
//		 * selectionBackground und selectionForeground gesetzt werden.
//		 */
//		setBackground(list.getSelectionBackground());
//		setForeground(list.getSelectionForeground());
//		setOpaque(true);
//	} else {/* sonst entsprechend dem background und foreground der table */
//		faerbeNormal(list);
//	}
//	/**
//	 * Die Methode faerbeNormal dient dazu, die Zelle nach dem normalen Vorder-
//	 * und Hintergrund einzufärben.
//	 * 
//	 * @param component
//	 */
//	private void faerbeNormal(JComponent component) {
//		setBackground(component.getBackground());
//		setForeground(component.getForeground());
//	}

}
