/**
 * AufrechnungPanel.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.forderungen;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.forderungen.ForderungNeuAction;
import eu.gronos.kostenrechner.controller.forderungen.ForderungsStaffelungPruefer;
import eu.gronos.kostenrechner.controller.forderungen.ForderungsStaffelungTenorAction;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.model.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.model.forderungen.Forderung;
import eu.gronos.kostenrechner.model.forderungen.ForderungenTableModel;
import eu.gronos.kostenrechner.model.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.view.GitterBeutelBeschraenkungen;
import eu.gronos.kostenrechner.view.KostenJPanel;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenCellEditor;
import eu.gronos.kostenrechner.view.menus.PopupMenuBuilder;

/**
 * Diese von {@link KostenJPanel} abgeleitete Klasse nimmt die
 * Oberflächenelemente für die Forderungsstaffelung auf.
 *
 * @author Peter Schuster (setrok)
 * @date 13.06.2018
 *
 */
public class ForderungsStaffelungPanel extends KostenJPanel
		implements WerteLesbar<ForderungsStaffelung> {

	private static final long serialVersionUID = 1506079463701863627L;
	private static final ForderungsStaffelungPanel instance = new ForderungsStaffelungPanel();
	private Kostenrechner kostenrechner;
	public JComboBox<Beteiligter> cbAngriffsKlaeger;
	public AbstractAction neueForderungAction = new ForderungNeuAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(42021));// , KeyEvent.VK_H
	public AbstractAction angriffsVerteidigungsmittelStaffelungAction = new ForderungsStaffelungTenorAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(43011));
	public JComboBox<Beteiligter> cbVerteidigungsBeklagter;
	public ForderungenTableModel ftm;
	public JTable tbForderungen;
	private static final ForderungenRenderer FORDERUNGEN_RENDERER = new ForderungenRenderer();
	private final ParsendUndBauend<ForderungsStaffelung> pruefer = new ForderungsStaffelungPruefer();

	/**
	 * Der Konstruktor ruft nur die Oberklasse auf.
	 * 
	 */
	private ForderungsStaffelungPanel() {
		super();
		// Kostenrechner.getLogger().info("Starte Panel.");
	}

	/**
	 * @return gibt {@link #instance} als AufrechnungPanel zurück.
	 */
	public static ForderungsStaffelungPanel getInstance() {
		return instance;
	}

	/**
	 * Die Methode setzt die Oberflächenelemente für die Registerkarte 3
	 * Hilfsaufrechnung.
	 * 
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#buildPanel()
	 */
	@Override
	public void buildPanel() {
		JPanel pnParteien = super.createPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(41000),
				new GridBagLayout());

		JLabel lblKlBezeichner = (JLabel) beschrifter.beschrifte(new JLabel(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(41001));
		lblKlBezeichner.setHorizontalAlignment(SwingConstants.RIGHT);
		Beteiligter[] klBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(Beteiligter.KLAEGER, true);
		// Sonst gibt es Warnungen bei der expliziten Typkonversion
		cbAngriffsKlaeger = new JComboBox<Beteiligter>(klBezeichnerListe);
		beschrifter.beschrifte(cbAngriffsKlaeger, NameContainerSammlung.BESCHRIFTUNGEN.get(41005));
		cbAngriffsKlaeger.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
		lblKlBezeichner.setLabelFor(cbAngriffsKlaeger);

		JLabel lblBkBezeichner = (JLabel) beschrifter.beschrifte(new JLabel(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(41011));
		lblBkBezeichner.setHorizontalAlignment(SwingConstants.RIGHT);

		Beteiligter[] bkBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(Beteiligter.BEKLAGTE, true);
		// Sonst gibt es Warnungen bei der expliziten Typkonversion
		cbVerteidigungsBeklagter = new JComboBox<Beteiligter>(bkBezeichnerListe);
		beschrifter.beschrifte(cbVerteidigungsBeklagter, NameContainerSammlung.BESCHRIFTUNGEN.get(41015));
		cbVerteidigungsBeklagter.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);

		JPanel pnForderungen = super.createPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(42000),
				new GridBagLayout());
		JLabel lblForderungen = (JLabel) beschrifter.beschrifte(new JLabel(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(42001));

		tbForderungen = (JTable) beschrifter.beschrifte(new JTable(), NameContainerSammlung.BESCHRIFTUNGEN.get(42015));
		leereWerte();
		entferneTastaturFalle(tbForderungen);
		tbForderungen.setDefaultRenderer(Forderung.class, ForderungsStaffelungPanel.FORDERUNGEN_RENDERER);
		tbForderungen.setDefaultRenderer(Double.class, KostenJPanel.EURO_RENDERER);
		tbForderungen.setDefaultEditor(Double.class, KostenJPanel.EURO_EDITOR);
		JComboBox<Forderung> cbForderungen = new JComboBox<Forderung>(ForderungHinzufuegen.sammleForderungen());
		cbForderungen.setRenderer(ForderungsStaffelungPanel.FORDERUNGEN_RENDERER);
		tbForderungen.setDefaultEditor(Forderung.class, new DefaultCellEditor(cbForderungen));
		tbForderungen.getTableHeader().setDefaultRenderer(KostenJPanel.HEADER_RENDERER);

		JScrollPane scpForderungen = (JScrollPane) beschrifter.beschrifte(new JScrollPane(tbForderungen),
				NameContainerSammlung.BESCHRIFTUNGEN.get(42010));
		lblForderungen.setLabelFor(scpForderungen);

		JButton btnNeueForderung = ((BeschriebeneAktion) neueForderungAction).toButton();

		JButton btnAngriffsVerteidigungsmittelStaffelung = ((BeschriebeneAktion) angriffsVerteidigungsmittelStaffelungAction)
				.toButton();

		pnParteien.add(lblKlBezeichner,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		pnParteien.add(cbAngriffsKlaeger,
				GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		pnParteien.add(lblBkBezeichner,
				GitterBeutelBeschraenkungen.getInstance(2, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		pnParteien.add(cbVerteidigungsBeklagter,
				GitterBeutelBeschraenkungen.getInstance(3, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		add(pnParteien, GitterBeutelBeschraenkungen.getInstance(0, 0, 2, 1, GridBagConstraints.HORIZONTAL, false));

		pnForderungen.add(lblForderungen,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		pnForderungen.add(scpForderungen,
				GitterBeutelBeschraenkungen.getInstance(0, 1, 2, 1, GridBagConstraints.BOTH, false));
		pnForderungen.add(btnNeueForderung,
				GitterBeutelBeschraenkungen.getInstance(0, 2, 2, 1, GridBagConstraints.HORIZONTAL, false));
		add(pnForderungen, GitterBeutelBeschraenkungen.getInstance(0, 2, 2, 3, GridBagConstraints.BOTH, false));

		add(btnAngriffsVerteidigungsmittelStaffelung,
				GitterBeutelBeschraenkungen.getInstance(0, 5, 2, 1, GridBagConstraints.HORIZONTAL, false));

		final PopupMenuBuilder builder = new PopupMenuBuilder();
		builder.build((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(44000), tbForderungen,
				new Integer[] { 1 }, (BeschriebeneAktion) neueForderungAction,
				(BeschriebeneAktion) eintragEntfernenAktion);

		logDauer();
	}

	/**
	 * Die Methode leert die Tabelle mit den Forderungen und ersetzt mit denen aus
	 * dem {@link ForderungsStaffelung}-Behälter. Zudem werden
	 * {@link #cbAngriffsKlaeger} und {@link #cbVerteidigungsBeklagter} angepasst.
	 * 
	 * @param staffelung {@link ForderungsStaffelung}
	 *
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#setzeWerte(java.lang.Object)
	 */
	@Override
	public void setzeWerte(final ForderungsStaffelung container) {
		cbAngriffsKlaeger.setSelectedItem(container.parteien.get(0));
		cbVerteidigungsBeklagter.setSelectedItem(container.parteien.get(1));
		ftm = new ForderungenTableModel();
		ftm.setAllValues(container.forderungen);
		tbForderungen.setModel(ftm);
	}

	/**
	 * Die Methode leert die Tabelle mit den Forderungen.
	 * 
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#leereWerte()
	 */
	public void leereWerte() {
		if (tbForderungen != null) {
			ftm = new ForderungenTableModel();
			tbForderungen.setModel(ftm);
		}
	}

	/**
	 * Die Methode dient dazu, alle Programmzustände in einen
	 * {@link VerfahrensDatenContainer} zu packen
	 * 
	 * @return den Untercontainer von {@link VerfahrensDatenContainer#staffelung}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#baueRueckgabewert()
	 */
	@Override
	public ForderungsStaffelung baueRueckgabewert() {
		pruefer.leseComponents(cbAngriffsKlaeger, cbVerteidigungsBeklagter, tbForderungen).parseEingabe();
		return pruefer.getRueckgabewert();
	}

	/**
	 * Die Methode dient dazu, eine Referenz auf das Hauptfenster zu übermitteln
	 * 
	 * @param kostenrechner
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#setKostenrechner(eu.gronos.kostenrechner.Kostenrechner)
	 */
	public void setKostenrechner(Kostenrechner kostenrechner) {
		this.kostenrechner = kostenrechner;
	}

	/**
	 * @return gibt {@link #kostenrechner} als Kostenrechner zurück.
	 */
	public Kostenrechner getKostenrechner() {
		return kostenrechner;
	}

}
// private JPopupMenu pmForderungen;
// public static final String FORDERUNGEN_POPUPLABEL =
// "Angriffs-/Verteidigungsmittel...";
// "Angriffs-/Verteidigungsmittel hinzufügen",, "forderung-neu"
// "Fügt ein neues Angriffs- oder Verteidigungsmittel zur Tabelle hinzu",
//	,			"Tenor ermitteln (Hilfsaufrechnung)","aufrechnung-tenor"
//			"Ermittelt den Kostentenor und Streitwert bei Staffelung von Hauptsache und Aufrechnungen.",
// new JButton(angriffsVerteidigungsmittelStaffelungAction);
// new JLabel("Parteien:", SwingConstants.RIGHT);
// lblKlBezeichner.setDisplayedMnemonic(KeyEvent.VK_P);
// new JComboBox<Beteiligter>(klBezeichnerListe);
// new JComboBox<Beteiligter>(bkBezeichnerListe);
// new JLabel("Bitte Angriffs- und Verteidigungsmittel angeben:");
// lblForderungen.setDisplayedMnemonic(KeyEvent.VK_V);
// kostenrechner.setzeForderungsTabellen();
// tbForderungen.setFillsViewportHeight(true);
// new JButton(neueForderungAction);
// add(lblKlBezeichner, GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1,
// GridBagConstraints.HORIZONTAL, false));
// add(cbAngriffsKlaeger,
// GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1,
// GridBagConstraints.HORIZONTAL, false));
// add(cbVerteidigungsBeklagter,
// GitterBeutelBeschraenkungen.getInstance(1, 1, 1, 1,
// GridBagConstraints.HORIZONTAL, false));
// add(lblForderungen, GitterBeutelBeschraenkungen.getInstance(0, 2, 1, 1,
// GridBagConstraints.HORIZONTAL, false));
// GitterBeutelBeschraenkungen.getInstance(0, 3, 2, 1, GridBagConstraints.BOTH,
// false));
// GitterBeutelBeschraenkungen.getInstance(0, 4, 2, 1,
// GridBagConstraints.HORIZONTAL, false));
// pmForderungen = new
// JPopupMenu(ForderungsStaffelungPanel.FORDERUNGEN_POPUPLABEL);
// pmForderungen.add(new
// JMenuItem(ForderungsStaffelungPanel.FORDERUNGEN_POPUPLABEL));
// pmForderungen.addSeparator();
// pmForderungen.add(new JMenuItem(neueForderungAction));
// pmForderungen.add(new JMenuItem(eintragEntfernenAktion));
// tbForderungen.addMouseListener(new KontextMouseListener(tbForderungen,
// pmForderungen));
