/**
 * GebuehrensatzRenderer.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.gebuehren;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

import eu.gronos.kostenrechner.model.gebuehren.AuslagenTatbestand;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenAnrechnungsTatbestand;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenErhoehungsTatbestand;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenSatzTatbestand;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.model.gebuehren.MehrfachPauschalTatbestand;
import eu.gronos.kostenrechner.model.gebuehren.MehrwertsteuerTatbestand;
import eu.gronos.kostenrechner.model.gebuehren.PauschalTatbestand;
import eu.gronos.kostenrechner.view.KostenTableRenderer;

/**
 * Stellt Gebührensätze dar mit einer Nachkommastelle dar.
 * 
 * @author Peter Felix Schuster (SchusterP2)
 * @date: 29.07.2014
 *
 */
public class GebuehrenTableRenderer extends KostenTableRenderer implements TableCellRenderer {

	private static final long serialVersionUID = -204281833673733183L;

	public GebuehrenTableRenderer() {
		super();
		setOpaque(true);
	}

	/**
	 * Rendert Tabellenzellen als JLabel.
	 * 
	 * @param table      the JTable that is asking the renderer to draw; can be null
	 * @param value      the value of the cell to be rendered. It is up to the
	 *                   specific renderer to interpret and draw the value. For
	 *                   example, if value is the string "true", it could be
	 *                   rendered as a string or it could be rendered as a check box
	 *                   that is checked. null is a valid value
	 * @param isSelected true if the cell is to be rendered with the selection
	 *                   highlighted; otherwise false
	 * @param hasFocus   if true, render cell appropriately. For example, put a
	 *                   special border on the cell, if the cell can be edited,
	 *                   render in the color used to indicate editing
	 * @param row        the row index of the cell being drawn. When drawing the
	 *                   header, the value of row is -1
	 * @param column     the column index of the cell being drawn
	 * @return ein JLabel, das entweder einen Euro-Betrag mit zwei Nachkommastellen
	 *         (bei einem Auslagentatbestand) oder einen Gebührensatz mit einer
	 *         Nachkommastelle (ansonsten) darstellt.
	 * 
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable,
	 *      java.lang.Object, boolean, boolean, int, int)
	 */
	@Override
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus,
			int row, int column) {
		if (table.getModel() instanceof GebuehrenTableModel) {
			GebuehrenTableModel gttm = ((GebuehrenTableModel) table.getModel());
			GebuehrenTatbestand tb = gttm.getAllValues().get(row);
			if (tb instanceof MehrfachPauschalTatbestand) {
				MehrfachPauschalTatbestand mptb = (MehrfachPauschalTatbestand) tb;
				setText(String.format("%,.2f EUR (%d %s)", value, mptb.getAnzahl(), mptb.getEinheit()));
			} else if (tb instanceof AuslagenTatbestand) {
				setText(String.format("%,.2f EUR", value));
			} else if (tb instanceof PauschalTatbestand) {
				setText(String.format("%,.2f EUR", value));
			} else if (tb instanceof GebuehrenErhoehungsTatbestand) {
				GebuehrenErhoehungsTatbestand getb = (GebuehrenErhoehungsTatbestand) tb;
				setText(String.format("%,.2f-fach (%d %s)", value, getb.getAnzahl(), getb.getEinheit()));
			} else if (tb instanceof GebuehrenAnrechnungsTatbestand) {
				setText(String.format("%,.2f-fach", value));
			} else if (tb instanceof GebuehrenSatzTatbestand) {
				setText(String.format("%,.1f-fach", value));
			} else if (tb instanceof MehrwertsteuerTatbestand) {
				if (value == null)// TODO Hä?
					System.err.printf("value == null bei: (%d, %d): %s", row, column, tb.toString());
				else
					setText(String.format("%,.1f%%", (Double) value * 100.0));
			}
			setHorizontalAlignment(SwingConstants.RIGHT);
		} else
			setText(Double.toString((Double) value));
		setSelected(isSelected);
		return this;
	}

//	if (isSelected) {
//		/*
//		 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend gesetzt werden.
//		 */
//		setBackground(table.getSelectionBackground());
//		setForeground(table.getSelectionForeground());
//	} else {/* sonst zurücksetzen */
//		setBackground(table.getBackground());
//		setForeground(table.getForeground());
//	}
	/*
	 * getListCellRendererComponent:
	 * 
	 * @param list The JList we're painting.
	 * 
	 * @param value the value of the cell to be rendered. It is up to the specific
	 * renderer to interpret and draw the value. For example, if value is the string
	 * "true", it could be rendered as a string or it could be rendered as a check
	 * box that is checked. null is a valid value
	 * 
	 * @param index The cells index.
	 * 
	 * @param isSelected True if the specified cell was selected.
	 * 
	 * @param cellHasFocus True if the specified cell has the focus.
	 * 
	 * @return ein JLabel, das entweder einen Euro-Betrag mit zwei Nachkommastellen
	 * (bei einem Auslagentatbestand) oder einen Gebührensatz mit einer
	 * Nachkommastelle (ansonsten) darstellt.
	 * 
	 * @see
	 * javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList,
	 * java.lang.Object, int, boolean, boolean) public Component
	 * getListCellRendererComponent(JList<? extends Double> list, Double value, int
	 * index, boolean isSelected, boolean cellHasFocus) {
	 * setText(String.format("%,.1f", value)); if (isSelected) {
	 * setBackground(list.getSelectionBackground());
	 * setForeground(list.getSelectionForeground()); setOpaque(true); } else {
	 * setBackground(list.getBackground()); setForeground(list.getForeground()); }
	 * return this; }
	 */

	/*
	 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend gesetzt werden.
	 *//* sonst nicht */
}
