/**
 * StreitwertReduktionPanel.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.gebuehren;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrNeuAction;
import eu.gronos.kostenrechner.controller.gebuehren.StreitwertReduktionHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageTenorAction;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageTerminAction;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageVerschiebenAction;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageruecknahmePruefer;
import eu.gronos.kostenrechner.controller.system.BooleanConfigOptionHorcher;
import eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.model.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.model.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.model.beschriftungen.SchluesselBeschriftung;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenVerzeichnis;
import eu.gronos.kostenrechner.model.gebuehren.Teilklageruecknahme;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.view.GitterBeutelBeschraenkungen;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.KostenJPanel;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenCellEditor;
import eu.gronos.kostenrechner.view.menus.PopupMenuBuilder;

/**
 * Diese von {@link KostenJPanel} abgeleitete Klasse nimmt die
 * Oberflächenelemente für die Streitwertreduktion auf.
 *
 * @author Peter Schuster (setrok)
 * @date 13.06.2018
 *
 */
public class TeilklageruecknahmePanel extends KostenJPanel
		implements WerteLesbar<Teilklageruecknahme>, GebuehrenTableTextfieldHandler {
	private static final long serialVersionUID = 1618328009895591401L;
	private static final TeilklageruecknahmePanel instance = new TeilklageruecknahmePanel();
	private Kostenrechner kostenrechner;
	JComboBox<Beteiligter> cbBeklagte;
	JComboBox<Beteiligter> cbKlaeger;
	private JFormattedTextField ftfStreitwertVorher;
	public JTable tabVorher;
	private GebuehrenTableModel gttmVorher;
	private final AbstractAction neueGebuehrVorherAction = new GebuehrNeuAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(12021), TABLE_FTF_VORHER);
	private final AbstractAction neueGebuehrNachherAction = new GebuehrNeuAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(13021), TABLE_FTF_NACHHER);

	private final BooleanConfigOptionHorcher berechnungsMethodeAction = new BooleanConfigOptionHorcher(
			(SchluesselBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(15001));

	// private final /* AbstractAction */TeilklageMethodeAction
	// berechnungsMethodeAction = new TeilklageMethodeAction(
	// (SchluesselBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(15001));

	private final AbstractAction tenorErmittelnAction = new TeilklageTenorAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(15005));
	private final AbstractAction gebuehrenTbVerschiebenAction = new TeilklageVerschiebenAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(17111));
	public AbstractAction klageruecknahmeTerminAction = new TeilklageTerminAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(17121));

	private JFormattedTextField ftfStreitwertNachher;
	private JFormattedTextField ftfObsiegen;

	private final FocusListener streitwertListener = new StreitwertReduktionHorcher(this);
	public JTable tabNachher;
	private GebuehrenTableModel gttmNachher;
	// private JPopupMenu pmGttmVorher;
	// private JPopupMenu pmGttmNachher;
	public static final String FEHLER_KEINE_GEBUEHREN = "Fehler: Keine Gebühren angefallen!";
	public static final String FEHLER_KEINE_GEBUEHREN_LANG = "Bitte geben Sie zunächst ein welche Gebühren vor und/oder nach der Streitwertreduktion angefallen waren.";
	// public static final String VORHER_POPUPLABEL = "Gebühren vorher...";
	// public static final String NACHHER_POPUPLABEL = "Gebühren nachher...";
	public static final int TABLE_FTF_VORHER = 0;
	public static final int TABLE_FTF_NACHHER = 1;
	public static final int FTF_OBSIEGEN = 2;
	private static final int TAB_TEILKLAGE = 0;
	private JToggleButton btnBerechnungsMethode;
	private JLabel lblStreitwertVorReduktion;
	private JLabel lblStreitwertNachReduktion;
	private JLabel lblLetztlichObsiegt;
	private ParsendUndBauend<Teilklageruecknahme> pruefer = new TeilklageruecknahmePruefer();

	/**
	 * Der Konstruktor ruft die Oberklasse auf.
	 * 
	 */
	private TeilklageruecknahmePanel() {
		super();
		// Kostenrechner.getLogger().info("Starte Panel");
		// String.format(, 2)
		// Kostenrechner.getInstance().getTabbedPane().indexOfComponent(this)
	}

	/**
	 * Das Panel ist als Singelton ausgestatltet. Diese Methode gibt die alleinige
	 * Instanz zurück.
	 * 
	 * @return gibt {@link #instance} als TeilklageruecknahmePanel zurück.
	 */
	public static TeilklageruecknahmePanel getInstance() {
		return instance;
	}

	/**
	 * Die Methode setzt die Oberflächenelemente für die Registerkarte 1
	 * Teilklagerücknahme
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#buildPanel()
	 */
	@Override
	public void buildPanel() {
		JPanel pnParteien = super.createPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(11000),
				new GridBagLayout());

		JLabel lblKlBezeichner = (JLabel) beschrifter.beschrifte(new JLabel(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(11001));
		lblKlBezeichner.setHorizontalAlignment(SwingConstants.RIGHT);

		Beteiligter[] klBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(Beteiligter.KLAEGER, true);
		cbKlaeger = new JComboBox<Beteiligter>(klBezeichnerListe);
		beschrifter.beschrifte(cbKlaeger, NameContainerSammlung.BESCHRIFTUNGEN.get(11005));
		cbKlaeger.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
		lblKlBezeichner.setLabelFor(cbKlaeger);

		JLabel lblBkBezeichner = (JLabel) beschrifter.beschrifte(new JLabel(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(11011));
		lblBkBezeichner.setHorizontalAlignment(SwingConstants.RIGHT);

		Beteiligter[] bkBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(Beteiligter.BEKLAGTE, true);
		cbBeklagte = new JComboBox<Beteiligter>(bkBezeichnerListe);
		beschrifter.beschrifte(cbBeklagte, NameContainerSammlung.BESCHRIFTUNGEN.get(11015));
		cbBeklagte.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
		lblBkBezeichner.setLabelFor(cbBeklagte);

		JPanel pnVorher = super.createPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(12000),
				new GridBagLayout());
		lblStreitwertVorReduktion = (JLabel) beschrifter.beschrifte(new JLabel(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(12001));
		lblStreitwertVorReduktion.setHorizontalAlignment(SwingConstants.RIGHT);

		ftfStreitwertVorher = (JFormattedTextField) beschrifter.beschrifte(
				new JFormattedTextField(KostenJPanel.FORMATTER_INT), NameContainerSammlung.BESCHRIFTUNGEN.get(12005));
		ftfStreitwertVorher.setColumns(10);
		ftfStreitwertVorher.addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
		ftfStreitwertVorher.setHorizontalAlignment(JTextField.RIGHT);
		lblStreitwertVorReduktion.setLabelFor(ftfStreitwertVorher);

		// leereWerte() geht hier noch nicht, weil der auch die Textfelder braucht
		leereGebuehrenTabellen();

		tabVorher = (JTable) beschrifter.beschrifte(new JTable(getGttmVorher()),
				NameContainerSammlung.BESCHRIFTUNGEN.get(12011));
		entferneTastaturFalle(tabVorher);
		setzeGebuehrenTabelleAussehen(tabVorher);
		JScrollPane scpVorher = (JScrollPane) beschrifter.beschrifte(new JScrollPane(tabVorher),
				NameContainerSammlung.BESCHRIFTUNGEN.get(12010));

		JButton btnNeueGebhrvorher = ((BeschriebeneAktion) neueGebuehrVorherAction).toButton();

		JPanel pnNachher = super.createPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(13000),
				new GridBagLayout());

		lblStreitwertNachReduktion = (JLabel) beschrifter.beschrifte(new JLabel(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(13001));
		lblStreitwertNachReduktion.setHorizontalAlignment(SwingConstants.RIGHT);

		setFtfStreitwertNachher((JFormattedTextField) beschrifter.beschrifte(
				new JFormattedTextField(KostenJPanel.FORMATTER_INT), NameContainerSammlung.BESCHRIFTUNGEN.get(13005)));
		getFtfStreitwertNachher().setColumns(10);
		getFtfStreitwertNachher().addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
		getFtfStreitwertNachher().addFocusListener(streitwertListener);
		getFtfStreitwertNachher().setHorizontalAlignment(JTextField.RIGHT);
		lblStreitwertNachReduktion.setLabelFor(getFtfStreitwertNachher());

		tabNachher = (JTable) beschrifter.beschrifte(new JTable(getGttmNachher()),
				NameContainerSammlung.BESCHRIFTUNGEN.get(13011));
		entferneTastaturFalle(tabNachher);
		setzeGebuehrenTabelleAussehen(tabNachher);
		JScrollPane scpNachher = (JScrollPane) beschrifter.beschrifte(new JScrollPane(tabNachher),
				NameContainerSammlung.BESCHRIFTUNGEN.get(13010));

		JButton btnNeueGebhrnachher = ((BeschriebeneAktion) neueGebuehrNachherAction).toButton();

		JPanel pnLetztlichObsiegt = super.createPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(14000),
				new GridBagLayout());
		lblLetztlichObsiegt = (JLabel) beschrifter.beschrifte(new JLabel(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(14001));
		lblLetztlichObsiegt.setHorizontalAlignment(SwingConstants.RIGHT);

		setFtfObsiegen((JFormattedTextField) beschrifter.beschrifte(new JFormattedTextField(KostenJPanel.FORMATTER_INT),
				NameContainerSammlung.BESCHRIFTUNGEN.get(14005)));
		getFtfObsiegen().addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
		getFtfObsiegen().setHorizontalAlignment(JTextField.RIGHT);
		lblLetztlichObsiegt.setLabelFor(getFtfObsiegen());

		leereTextfelder();

		btnBerechnungsMethode = (JToggleButton) berechnungsMethodeAction.toButton();
		// (JToggleButton) ((BeschriebeneAktion) berechnungsMethodeAction)
		// .toButton(new BooleanConfigOptionHorcher(
		// new BooleanConfigSchluessel("quotenMethodeVorziehen", true),
		// (SchluesselBeschriftung) ((BeschriebeneAktion)
		// berechnungsMethodeAction).getBeschriftung())
		// .toButton());

		// new JToggleButton()
		// new JToggleButton(berechnungsMethodeAction);
		// btnBerechnungsMethode.addItemListener(new BooleanConfigOptionHorcher(
		// new BooleanConfigSchluessel("quotenMethodeVorziehen", true),
		// btnBerechnungsMethode));
		// Einmal actionPerformed() auslösen, um den Text der Auswahl anzupassen
		// berechnungsMethodeAction.actionPerformed(new
		// ActionEvent(btnBerechnungsMethode, ActionEvent.ACTION_FIRST,
		// btnBerechnungsMethode.getActionCommand()));

		JButton btnBerechneTeilklageruecknahme = ((BeschriebeneAktion) tenorErmittelnAction).toButton();

		pnParteien.add(lblKlBezeichner,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		pnParteien.add(cbKlaeger,
				GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		pnParteien.add(lblBkBezeichner,
				GitterBeutelBeschraenkungen.getInstance(2, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		pnParteien.add(cbBeklagte,
				GitterBeutelBeschraenkungen.getInstance(3, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		add(pnParteien, GitterBeutelBeschraenkungen.getInstance(0, 0, 3, 1, GridBagConstraints.HORIZONTAL, false));
		pnVorher.add(lblStreitwertVorReduktion,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		pnVorher.add(ftfStreitwertVorher,
				GitterBeutelBeschraenkungen.getInstance(1, 0, 2, 1, GridBagConstraints.HORIZONTAL, false));
		pnVorher.add(scpVorher, GitterBeutelBeschraenkungen.getInstance(0, 1, 3, 1, GridBagConstraints.BOTH, false));
		pnVorher.add(btnNeueGebhrvorher,
				GitterBeutelBeschraenkungen.getInstance(0, 2, 3, 1, GridBagConstraints.HORIZONTAL, false));
		add(pnVorher, GitterBeutelBeschraenkungen.getInstance(0, 1, 3, 2, GridBagConstraints.BOTH, false));
		pnNachher.add(lblStreitwertNachReduktion,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		pnNachher.add(getFtfStreitwertNachher(),
				GitterBeutelBeschraenkungen.getInstance(1, 0, 2, 1, GridBagConstraints.HORIZONTAL, false));
		pnNachher.add(scpNachher, GitterBeutelBeschraenkungen.getInstance(0, 1, 3, 1, GridBagConstraints.BOTH, false));
		pnNachher.add(btnNeueGebhrnachher,
				GitterBeutelBeschraenkungen.getInstance(0, 2, 3, 1, GridBagConstraints.HORIZONTAL, false));
		add(pnNachher, GitterBeutelBeschraenkungen.getInstance(0, 4, 3, 2, GridBagConstraints.BOTH, false));
		pnLetztlichObsiegt.add(lblLetztlichObsiegt,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		pnLetztlichObsiegt.add(getFtfObsiegen(),
				GitterBeutelBeschraenkungen.getInstance(1, 0, 2, 1, GridBagConstraints.HORIZONTAL, false));
		add(pnLetztlichObsiegt,
				GitterBeutelBeschraenkungen.getInstance(0, 8, 3, 1, GridBagConstraints.HORIZONTAL, false));
		add(btnBerechnungsMethode,
				GitterBeutelBeschraenkungen.getInstance(0, 9, 3, 1, GridBagConstraints.HORIZONTAL, false));
		add(btnBerechneTeilklageruecknahme,
				GitterBeutelBeschraenkungen.getInstance(0, 10, 3, 1, GridBagConstraints.HORIZONTAL, false));

		final PopupMenuBuilder builder = new PopupMenuBuilder();
		builder.build((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(17100), tabVorher, new Integer[] { 1 },
				(BeschriebeneAktion) neueGebuehrVorherAction, (BeschriebeneAktion) klageruecknahmeTerminAction,
				(BeschriebeneAktion) eintragEntfernenAktion, (BeschriebeneAktion) gebuehrenTbVerschiebenAction);

		builder.build((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(17200), tabNachher, new Integer[] { 1 },
				(BeschriebeneAktion) neueGebuehrNachherAction, (BeschriebeneAktion) klageruecknahmeTerminAction,
				(BeschriebeneAktion) eintragEntfernenAktion, (BeschriebeneAktion) gebuehrenTbVerschiebenAction);

		logDauer();
	}

	/**
	 * Die Methode leert alle Tabellen und Textfelder der Streitwertreduktion
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#leereWerte()
	 */
	@Override
	public void leereWerte() {
		leereGebuehrenTabellen();// false
		leereTextfelder();
	}

	/**
	 * Die Methode leert alle Tabellen der Streitwertreduktion oder füllt sie mit
	 * den Tatbeständen zum aus dem {@link Teilklageruecknahme}-Behälter. Zudem
	 * füllt sie die {@link JFormattedTextField} mit den Streitwertangaben.
	 * 
	 * @param container ein {@link Teilklageruecknahme} -Behälter
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#setzeWerte(Streitgenossen,
	 *      java.lang.Object)
	 */
	@Override
	public void setzeWerte(final Teilklageruecknahme container) {
		cbKlaeger.setSelectedItem(container.parteien.get(0));
		cbBeklagte.setSelectedItem(container.parteien.get(1));
		ftfStreitwertVorher.setText(container.streitwerteUndObsiegen.get(0).toString());
		getFtfStreitwertNachher().setText(container.streitwerteUndObsiegen.get(1).toString());
		getFtfObsiegen().setText(container.streitwerteUndObsiegen.get(2).toString());
		setGttmVorher(new GebuehrenTableModel(container.vorher));
		tabVorher.setModel(getGttmVorher());
		setGttmNachher(new GebuehrenTableModel(container.nachher));
		tabNachher.setModel(getGttmNachher());
		Kostenrechner.getLogger().info("Fertig!");
	}

	/**
	 * Die Methode dient dazu, alle Programmzustände in einen
	 * {@link VerfahrensDatenContainer} zu packen
	 * 
	 * @return den Untercontainer von
	 *         {@link VerfahrensDatenContainer#teilklageruecknahme}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#baueRueckgabewert()
	 */
	@Override
	public Teilklageruecknahme baueRueckgabewert() {
		pruefer.leseComponents(cbKlaeger, cbBeklagte, tabVorher, tabNachher, getFormattedTextField(TABLE_FTF_VORHER),
				getFormattedTextField(TABLE_FTF_NACHHER), getFormattedTextField(FTF_OBSIEGEN)).parseEingabe();
		return pruefer.getRueckgabewert();
	}

	/**
	 * Die Methode dient dazu, eine Referenz auf das Hauptfenster zu übermitteln
	 * 
	 * @param kostenrechner
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#setKostenrechner(eu.gronos.kostenrechner.Kostenrechner)
	 */
	@Override
	public void setKostenrechner(Kostenrechner kostenrechner) {
		this.kostenrechner = kostenrechner;
	}

	/**
	 * Die Methode prüft, ob wenigstens eine der beiden
	 * GebuehrenTatbestandTableModels auf dem Tab für die Teilerledigung/-rücknahme
	 * Daten enhtält.
	 * 
	 * @return true, wenn eine der beiden GebuehrenTatbestandTableModels Daten
	 *         enthält; false, wenn beide leer sind.
	 */
	public boolean pruefeTabellen() {
		return getGttmVorher().getRowCount() > 0 || getGttmNachher().getRowCount() > 0;
	}

	/**
	 * Die Methode gibt ein {@link JFormattedTextField} der Wahl zurück.
	 * 
	 * @param index entweder {@link #TABLE_FTF_VORHER}, {@link #TABLE_FTF_NACHHER}
	 *              oder {@link #FTF_OBSIEGEN}
	 * @return gibt das gewählte {@link JFormattedTextField} zurück.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.PanelTextFieldHandler#getFormattedTextField(int)
	 */
	@Override
	public JFormattedTextField getFormattedTextField(int index) {
		switch (index) {
		case TABLE_FTF_VORHER:
			return this.ftfStreitwertVorher;
		case TABLE_FTF_NACHHER:
			return this.ftfStreitwertNachher;
		case FTF_OBSIEGEN:
			return this.ftfObsiegen;
		default:
			break;
		}
		return null;
	}

	/**
	 * Die Methode soll den Text des zum {@link JFormattedTextField} gehörenden
	 * {@link JLabel}s zurückgeben.
	 * 
	 * @param index entweder {@link #TABLE_FTF_VORHER}, {@link #TABLE_FTF_NACHHER}
	 *              oder {@link #FTF_OBSIEGEN}
	 * @return das {@link JLabel#getText()} als String
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.PanelTextFieldHandler#getLabelText(int)
	 */
	@Override
	public String getLabelText(int index) {
		switch (index) {
		case TABLE_FTF_VORHER:
			return this.lblStreitwertVorReduktion.getText();
		case TABLE_FTF_NACHHER:
			return this.lblStreitwertNachReduktion.getText();
		case FTF_OBSIEGEN:
			return this.lblLetztlichObsiegt.getText();
		default:
			break;
		}
		return null;
	}

	/**
	 * @param ftfStreitwertNachher d. {@link #ftfStreitwertNachher}, d. gesetzt
	 *                             werden soll als JFormattedTextField
	 */
	public void setFtfStreitwertNachher(JFormattedTextField ftfStreitwertNachher) {
		this.ftfStreitwertNachher = ftfStreitwertNachher;
	}

	/**
	 * @param ftfObsiegen d. {@link #ftfObsiegen}, d. gesetzt werden soll als
	 *                    JFormattedTextField
	 */
	public void setFtfObsiegen(JFormattedTextField ftfObsiegen) {
		this.ftfObsiegen = ftfObsiegen;
	}

	/**
	 * @return gibt {@link #kostenrechner} als Kostenrechner zurück.
	 */
	public Kostenrechner getKostenrechner() {
		return kostenrechner;
	}

	/**
	 * Die Methode gibt ein {@link GebuehrenTableModel} der Wahl zurück.
	 * 
	 * @param index entweder {@link #TABLE_FTF_VORHER} oder
	 *              {@link #TABLE_FTF_NACHHER}
	 * @return {@link #getGttmVorher()} oder {@link #getGttmNachher()}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.PanelTableModelHandler#getTableModel(int)
	 */
	@Override
	public GebuehrenTableModel getTableModel(int index) {
		if (index == TABLE_FTF_VORHER) {
			return getGttmVorher();
		} else if (index == TABLE_FTF_NACHHER) {
			return getGttmNachher();
		}
		throw new IndexOutOfBoundsException();
	}

	/**
	 * @return gibt {@link #gttmVorher} als GebuehrenTatbestandTableModel zurück.
	 */
	public GebuehrenTableModel getGttmVorher() {
		return gttmVorher;
	}

	/**
	 * @return gibt {@link #gttmNachher} als GebuehrenTatbestandTableModel zurück.
	 */
	public GebuehrenTableModel getGttmNachher() {
		return gttmNachher;
	}

	/*
	 * Die Methode gibt einen Fehler aus
	 * 
	 */
	// private void fehlerKeineGebuehren() {
	// Throwable e = new
	// IllegalArgumentException(TeilklageruecknahmePanel.FEHLER_KEINE_GEBUEHREN_LANG);
	// FehlerHelper.zeigeFehler(TeilklageruecknahmePanel.FEHLER_KEINE_GEBUEHREN +
	// "\n" + e.getLocalizedMessage(), e);
	// }

	/**
	 * Die Methode übergibt die gewählte Berechnungsmethode
	 * 
	 * @return
	 */
	public boolean isQuotenMethodeVorziehen() {
		if (btnBerechnungsMethode == null)
			return true;
		return btnBerechnungsMethode.isSelected();
	}

	/**
	 * Die Methode dient dazu, dass eine {@link BeschriebeneAktion} den Focus auf
	 * die {@link JComponent} legen kann, die sie aufruft.
	 * 
	 * @return <code>true</code>, wenn der Aufruf wahrscheinlich Erfolg hat;
	 *         <code>false</code>, wenn er zum Scheitern verurteilt ist.
	 * 
	 * @see javax.swing.JComponent#requestFocusInWindow()
	 */
	@Override
	public boolean requestFocusInWindow() {
		getKostenrechner().getTabbedPane().setSelectedIndex(TAB_TEILKLAGE);
		return super.requestFocusInWindow();
	}

	/**
	 * @return gibt {@link #ftfObsiegen} als JFormattedTextField zurück.
	 */
	private JFormattedTextField getFtfObsiegen() {
		return ftfObsiegen;
	}

	/**
	 * @return gibt {@link #ftfStreitwertNachher} als JFormattedTextField zurück.
	 */
	private JFormattedTextField getFtfStreitwertNachher() {
		return ftfStreitwertNachher;
	}

	/**
	 * Die Methode leert alle Textfelder der Streitwertreduktion
	 * 
	 */
	private void leereTextfelder() {
		ftfStreitwertVorher.setText("0");// "15000"
		getFtfStreitwertNachher().setText("0");// "10000"
		getFtfObsiegen().setText("0");// "10000"
	}

	/**
	 * Die Methode leert alle Tabellen der Streitwertreduktion
	 * 
	 */
	private void leereGebuehrenTabellen() {
		setGttmVorher(new GebuehrenTableModel(new GebuehrenVerzeichnis()));
		setGttmNachher(new GebuehrenTableModel(new GebuehrenVerzeichnis()));
		if (tabVorher != null)
			tabVorher.setModel(getGttmVorher());
		if (tabNachher != null)
			tabNachher.setModel(getGttmNachher());
	}

	/**
	 * @param gttmNachher d. {@link #gttmNachher}, d. gesetzt werden soll als
	 *                    GebuehrenTatbestandTableModel
	 */
	private void setGttmNachher(GebuehrenTableModel gttmNachher) {
		this.gttmNachher = gttmNachher;
	}

	/**
	 * @param gttmVorher d. {@link #gttmVorher}, d. gesetzt werden soll als
	 *                   GebuehrenTatbestandTableModel
	 */
	private void setGttmVorher(GebuehrenTableModel gttmVorher) {
		this.gttmVorher = gttmVorher;
	}

}

// ArrayList<GebuehrenTatbestand>
// ArrayList<GebuehrenTatbestand>
// Kostenrechner.getLogger()
// .info(String.format("Starte Panel %d",
// getKostenrechner().getTabbedPane().indexOfComponent(this)));
// Kostenrechner.getInstance().getTabbedPane().indexOfComponent(this)
// lblKlBezeichner.setDisplayedMnemonic(KeyEvent.VK_P);
// lblBkBezeichner.setDisplayedMnemonic(KeyEvent.VK_B);// 
//"Tenor ermitteln (Quoten-/Mehrkostenmethode)",
//"<html><h1>Tenor ermitteln</h1><p>"
//+ "Erzeugt den Kostentenor nach der ausgew&auml;hlten Berechnungsmethode."
//+ "</p></html>",
//, "teilklage-tenor"
//new GebuehrNeuAction(this,
//"Neue Gebühr (vor Teilklagerücknahme entstanden)",
//"<html><h1>Neue Gebühr (vor Teilklagerücknahme entstanden)</h1><p>Fügt einen vor der Teilklagerücknahme entstandenen Gebührentatbestand <br>in die (obere) Tabelle ein.</p></html>",
//KeyEvent.VK_V, "gebuehr-vorher", TABLE_FTF_VORHER);
//"Neue Gebühr (nach Teilklagerücknahme entstanden)",
//"<html><h1>Neue Gebühr (nach Teilklagerücknahme entstanden)</h1><p>"
//+ "Fügt einen nach der Teilklagerücknahme entstandenen Gebührentatbestand <br>in die (untere) Tabelle ein."
//+ "</p></html>",
//"gebuehr-nachher"
//, "standard-gebuehren"
//"Fall Teilklagerücknahme vor/im Termin",
//"Leert die Tabelle mit den Gebührentatbeständen und \nfüllt sie mit der Konstellation Teilklagerücknahme vor Anfall der Terminsgebühr",
//"Gebühr in die andere Tabelle verschieben",
//"Entfernt den markierten Eintrag aus dieser Tabelle und fügt ihn der jeweils anderen hinzu.",
//"verschiebe-gebuehr"
//			"Berechnungsmethode: Quotenmethode", "Berechnungsmethode: Mehrkostenmethode",
//			"<html><h1>Berechnungsmethode</h1><p>Auswahl, ob &bdquo;Tenor ermitteln&ldquo; nach der Quotenmethode (Standard) oder Mehrkostenmethode rechnet.</p></html>",
//			KeyEvent.VK_M, "teilklage-berechnungsmethode");

// JPanel pnParteien = new JPanel();
// pnParteien.setLayout(new BorderLayout());
// new JLabel("Parteien:", SwingConstants.RIGHT);
// add(lblParteien, GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1,
// GridBagConstraints.HORIZONTAL, false));
// , BorderLayout.LINE_START);
// add(cbKlaeger, GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1,
// GridBagConstraints.HORIZONTAL, false));
// , BorderLayout.CENTER);
// add(cbBeklagte, GitterBeutelBeschraenkungen.getInstance(2, 0, 1, 1,
// GridBagConstraints.HORIZONTAL, false));
// , BorderLayout.LINE_END);
// new JLabel("Streitwert vor Teilklagerücknahme", SwingConstants.RIGHT);
// add(lblStreitwertVorReduktion,
// GitterBeutelBeschraenkungen.getGitterBeutelBeschraenkungen(0,
// 2, 1,
// 1, false, false));
// GitterBeutelBeschraenkungen.getInstance(0, 1, 1, 1,
// GridBagConstraints.HORIZONTAL, false));
// new JFormattedTextField(KostenJPanel.FORMATTER_INT);
// add(ftfStreitwertVorher,
// GitterBeutelBeschraenkungen.getGitterBeutelBeschraenkungen(2,
// 2, 1,
// 1, false, false));
// GitterBeutelBeschraenkungen.getInstance(1, 1, 2, 1,
// GridBagConstraints.HORIZONTAL, false));
// add(scpVorher,
// GitterBeutelBeschraenkungen.getGitterBeutelBeschraenkungen(0,
// 3, 3,
// 1, true, false));
// GitterBeutelBeschraenkungen.getInstance(0, 2, 3, 1, GridBagConstraints.BOTH,
// false));
// new JButton(neueGebuehrVorherAction);
// add(btnNeueGebhrvorher,
// GitterBeutelBeschraenkungen.getInstance(0, 3, 3, 1,
// GridBagConstraints.HORIZONTAL, false));
// new JLabel("Streitwert nach Teilklagerücknahme", SwingConstants.RIGHT);
// add(lblStreitwertNachReduktion,
// GitterBeutelBeschraenkungen.getGitterBeutelBeschraenkungen(3,
// 2, 1,
// 1, false, false));
// GitterBeutelBeschraenkungen.getInstance(0, 4, 1, 1,
// GridBagConstraints.HORIZONTAL, false));
// new JFormattedTextField(KostenJPanel.FORMATTER_INT));
// add(getFtfStreitwertNachher(),
// GitterBeutelBeschraenkungen.getGitterBeutelBeschraenkungen(5,
// 2, 1,
// 1, false, false));
// GitterBeutelBeschraenkungen.getInstance(1, 4, 2, 1,
// GridBagConstraints.HORIZONTAL, false));
// add(scpNachher,
// GitterBeutelBeschraenkungen.getGitterBeutelBeschraenkungen(3,
// 3, 3,
// 1, true, false));
// GitterBeutelBeschraenkungen.getInstance(0, 5, 3, 1, GridBagConstraints.BOTH,
// false));
// new JButton(neueGebuehrNachherAction);
// add(btnNeueGebhrnachher,
// GitterBeutelBeschraenkungen.getInstance(0, 6, 3, 1,
// GridBagConstraints.HORIZONTAL, false));
// new JLabel("Letztlich obsiegt:", SwingConstants.RIGHT);
// add(lblLetztlichObsiegt,
// GitterBeutelBeschraenkungen.getInstance(0, 8, 1, 1,
// GridBagConstraints.HORIZONTAL, false));
// new JFormattedTextField(KostenJPanel.FORMATTER_INT));
//getFtfObsiegen().setColumns(31);
// add(getFtfObsiegen(),
// GitterBeutelBeschraenkungen.getInstance(1, 8, 2, 1,
// GridBagConstraints.HORIZONTAL, false));
// new JButton(tenorErmittelnAction);// (quotenMethodeAction);
//new JMenuItem(neueGebuehrVorherAction));
//new JMenuItem(klageruecknahmeTerminAction));
//new JMenuItem(eintragEntfernenAktion));
//new JMenuItem(gebuehrenTbVerschiebenAction));
//new JMenuItem(neueGebuehrNachherAction));
//new JMenuItem(klageruecknahmeTerminAction));
//new JMenuItem(eintragEntfernenAktion));
//new JMenuItem(gebuehrenTbVerschiebenAction));
//pmGttmVorher = new JPopupMenu(VORHER_POPUPLABEL);
//pmGttmVorher.add(new JMenuItem(VORHER_POPUPLABEL));
//pmGttmVorher.addSeparator();
//pmGttmVorher.add(((BeschriebeneAktion) neueGebuehrVorherAction).toMenuItem());
//pmGttmVorher.add(((BeschriebeneAktion) klageruecknahmeTerminAction).toMenuItem());
//pmGttmVorher.add(((BeschriebeneAktion) eintragEntfernenAktion).toMenuItem());
//pmGttmVorher.add(((BeschriebeneAktion) gebuehrenTbVerschiebenAction).toMenuItem());
//tabVorher.addMouseListener(new KontextMouseListener(tabVorher, pmGttmVorher));
//pmGttmNachher = new JPopupMenu(NACHHER_POPUPLABEL);
//pmGttmNachher.add(new JMenuItem(NACHHER_POPUPLABEL));
//pmGttmNachher.addSeparator();
//pmGttmNachher.add(((BeschriebeneAktion) neueGebuehrNachherAction).toMenuItem());
//pmGttmNachher.add(((BeschriebeneAktion) klageruecknahmeTerminAction).toMenuItem());
//pmGttmNachher.add(((BeschriebeneAktion) eintragEntfernenAktion).toMenuItem());
//pmGttmNachher.add(((BeschriebeneAktion) gebuehrenTbVerschiebenAction).toMenuItem());
//tabNachher.addMouseListener(new KontextMouseListener(tabNachher, pmGttmNachher));
// pmGttmNachher =