/*
 * AkzeptanzDialog.java
 * eu.gronos.kostenrechner.view.helpanderror (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.helpanderror;

import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.StyledDocument;

import eu.gronos.kostenrechner.controller.files.HtmlWerkzeugKasten;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.view.FontHelfer;
import eu.gronos.kostenrechner.view.GitterBeutelBeschraenkungen;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.result.FontHelferForWindow;

/**
 * Die Klasse ist ein {@link HinzufuegenDialog}, der nach der Zustimmung zur
 * Übersendung von Daten fragt.
 *
 * @author Peter Schuster (setrok)
 * @date 23 Apr 2019
 *
 */
//HinzufuegenDialog<Boolean>
public abstract class AkzeptanzDialog<T> extends HinzufuegenDialog<T> {

	private static final long serialVersionUID = -6845012067282320046L;
	private JTextPane textPane;
	// private HTMLEditorKit kit;
	private StyledDocument doc;
	private JScrollPane scrollPane;
	// private final HtmlWerkzeugKasten helper;
	private final HtmlWerkzeugKasten kit = new HtmlWerkzeugKasten();

	/**
	 * Konstruktor: erzeugt eine Instanz der {@link LizenzZustimmungDialog}.
	 * 
	 * @param owner ein {@link JFrame} oder {@link JDialog}
	 * @param title eine {@link Beschriftung} mit dem Titel usw.
	 * @throws HeadlessException
	 */
	public AkzeptanzDialog(Window owner, Beschriftung title) throws HeadlessException {
		super(owner, title);
		// kit = new HtmlWerkzeugKasten();
		// super.setAlwaysOnTop(true);
	}

	/**
	 * Wenn der {@link HinzufuegenDialog#getOkAction() Ok-Button} gedrückt wird, ist
	 * alles gut.
	 * 
	 * {@link HinzufuegenDialog}
	 * 
	 * @return <code>true</code>
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#parseEingabe()
	 */
	@Override
	public boolean parseEingabe() {
		return true;
	}

	/**
	 * @return gibt {@link #doc} als {@link StyledDocument} zurück.
	 */
	public StyledDocument getDoc() {
		return doc;
	}

	/**
	 * @return
	 * @return gibt {@link #kit} als {@link HtmlWerkzeugKasten} zurück.
	 */
	public HtmlWerkzeugKasten getKit() {
		return kit;
	}
	//

	// setKit(new HTMLEditorKit());
	// textPane.setEditorKit(getKit());
	// textPane.setEditable(false);
	// setDoc((StyledDocument) getKit().createDefaultDocument());
	// textPane.setStyledDocument(getDoc());
	// setHtml(resource);
	
	/**
	 * Die Methode dient dazu, die HTML-Datei einzulesen
	 * 
	 * @param resource der Name der HTML-Datei in den resources
	 */
	public void setHtml(String resource) {
		getKit().read(resource, textPane);// getDoc(), getKit()
		//getKit().createStyles();// HtmlWerkzeugKasten.KOSTENTENOR_CSS, getKit()
		// Caret ganz nach oben setzen
		//textPane.setCaretPosition(0);
	}

	/**
	 * Die Methode setzt eine {@link JTextPane} mit {@link JScrollPane} ins Fenster
	 * und lädt HTML.
	 * 
	 * @param resource der Name der HTML-Datei in den resources
	 */
	protected void baueTextPane(String resource) {
		textPane = (JTextPane) beschrifter.beschrifte(new JTextPane(), NameContainerSammlung.BESCHRIFTUNGEN.get(73011));
		textPane.setEditorKit(kit);
		getKit().read(resource, textPane);
		// setKit((HTMLEditorKit) textPane.getEditorKit());
		setDoc(textPane.getStyledDocument());

		FontHelferForWindow fufHelfer = new FontHelferForWindow(this);
		fufHelfer.setPreferredSizeFromAttributeSet(getDoc().getParagraphElement(0).getAttributes(),
				FontHelfer.MAX_SPALTEN, FontHelfer.MAX_ZEILEN);
		// scrollPane =
		setScrollPane((JScrollPane) beschrifter.beschrifte(new JScrollPane(textPane),
				NameContainerSammlung.BESCHRIFTUNGEN.get(73010)));
		// textPane.addHyperlinkListener(HinzufuegenDialog.HYPERLINK_LISTENER);
		contentPanel.add(scrollPane,
				GitterBeutelBeschraenkungen.getInstance(0, 1, 3, 3, GridBagConstraints.BOTH, true));
		setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
	}
	// setKit(new HTMLEditorKit());
	// textPane.setEditorKit(getKit());
	// textPane.setEditable(false);
	// setDoc((StyledDocument) getKit().createDefaultDocument());
	// textPane.setStyledDocument(getDoc());
	// setHtml(resource);

	/**
	 * @return gibt {@link #scrollPane} als {@link JScrollPane} zurück.
	 */
	protected JScrollPane getScrollPane() {
		return scrollPane;
	}

	/**
	 * @param scrollPane d. {@link #scrollPane}, d. gesetzt werden soll als
	 *                   {@link JScrollPane}.
	 */
	private void setScrollPane(JScrollPane scrollPane) {
		this.scrollPane = scrollPane;
	}

	/**
	 * @param doc d. {@link #doc}, d. gesetzt werden soll als
	 *            {@link StyledDocument}.
	 */
	private void setDoc(StyledDocument doc) {
		this.doc = doc;
	}

	/*
	 * @param kit d. {@link #kit}, d. gesetzt werden soll als {@link HTMLEditorKit}.
	 */
	// private void setKit(HtmlWerkzeugKasten kit) {
	// this.kit = kit;
	// }
	// HTMLEditorKit

}
//
///**
//* @return {@link Boolean#TRUE} - wenn Ok gedrückt wird, ist alles gut.
//* 
//* @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
//*/
//@Override //
//protected Boolean baueRueckgabewert() {
//	return Boolean.TRUE;
//}