/**
 * LizenzAkzeptanzHinzufuegen.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.helpanderror;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Window;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;

import eu.gronos.kostenrechner.controller.ComponentBeschrifter;
import eu.gronos.kostenrechner.controller.system.DatenschutzAblehnungAktion;
import eu.gronos.kostenrechner.controller.system.DatenschutzZustimmungAktion;
import eu.gronos.kostenrechner.interfaces.Vorsorgend;
import eu.gronos.kostenrechner.model.DatenschutzZustimmung;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainer;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.model.beschriftungen.VorsorgendeBeschriftung;
import eu.gronos.kostenrechner.view.GitterBeutelBeschraenkungen;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.TabbedPaneFactory;

/**
 * Ein {@link HinzufuegenDialog}, der vor dem Absenden einer E-Mail die
 * Zustimmung zur Datenübertragung abwartet.
 *
 * @author Peter Schuster (setrok)
 * @date 22 Apr 2019
 *
 */
//Boolean
public class DatenschutzZustimmungDialog extends AkzeptanzDialog<DatenschutzZustimmung> {

	private static final String RESOURCES_DSGVO_BASIS = "resources/dsgvo-basis.html";
	private static final String RESOURCES_DSGVO_ANHANG = "resources/dsgvo-anhang.html";
	private static final long serialVersionUID = 5974122103013004015L;
	private String htmlfile;
	private JTabbedPane tabbedPane;
	// private DatenschutzZustimmung rueckgabewert;
	private DatenschutzZustimmungAktion pruefer;
	private JLabel lblFrage;

	/**
	 * Konstruktor: erzeugt eine Instanz des {@link DatenschutzZustimmungDialog}.
	 * 
	 * @param owner      ein {@link JFrame} oder {@link JDialog}
	 * @param level      entweder
	 *                   {@link DatenschutzZustimmung#OPTION_DSGVO_EMAIL_BASIS} oder
	 *                   {@link DatenschutzZustimmung#OPTION_DSGVO_EMAIL_ANHANG}
	 * @param zustimmung die {@link DatenschutzZustimmung} mit dem bisherigen
	 *                   Zustand der Registry/Preferences
	 * @throws HeadlessException
	 */
	public DatenschutzZustimmungDialog(Window owner, int level, DatenschutzZustimmung zustimmung)
			throws HeadlessException {
		this(owner, true, level, zustimmung);
	}

	/**
	 * Konstruktor: erzeugt eine Instanz der {@link DatenschutzZustimmungDialog}.
	 * 
	 * @param owner            ein {@link JFrame} oder {@link JDialog}
	 * @param zustimmungNoetig wenn <code>true</code>, dann wird der OK-Button in
	 *                         "Ja, ich stimme zu!" umbenannt.
	 * @param level            entweder
	 *                         {@link DatenschutzZustimmung#OPTION_DSGVO_EMAIL_BASIS}
	 *                         oder
	 *                         {@link DatenschutzZustimmung#OPTION_DSGVO_EMAIL_ANHANG}
	 * @param zustimmung       die {@link DatenschutzZustimmung} mit dem bisherigen
	 *                         Zustand der Registry/Preferences
	 * @throws HeadlessException
	 */
	public DatenschutzZustimmungDialog(Window owner, boolean zustimmungNoetig, int level,
			DatenschutzZustimmung zustimmung) throws HeadlessException {
		super(owner, (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(74000));
		pruefer = new DatenschutzZustimmungAktion(this,
				(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(74051), level, zustimmung);
		baueTabbedPane(level);
		super.setOkButtonToBeFocussed(true);
		if (zustimmungNoetig) {
			// Ja-Button bauen
			super.getOkButton().setAction(pruefer);
		}
	}
	// pruefer.leseComponents(tabbedPane);
	// this.rueckgabewert = zustimmung;
	// NameContainerSammlung.BESCHRIFTUNGEN.get(74051).applyTo(super.getOkButton());

	/**
	 * Die Methode dient dazu, das {@link HinzufuegenDialog#contentPanel} auf das
	 * zweite Tab zu verschieben, die zugehörige HTML-Datei zu laden und auf das
	 * zweite Tab zu wechseln
	 * 
	 */
	public void wechseleTab() {
		tabbedPane.setComponentAt(0, new JPanel());
		tabbedPane.setComponentAt(1, contentPanel);
		setHtmlFile(DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG);
		activateTabs(1);
		super.setHtml(htmlfile);
		tabbedPane.setSelectedIndex(1);
		// Frage aktualisieren
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();
		// .applyTo
		beschrifter.beschrifte(lblFrage,
				(NameContainer) beschrifter.changeTo(
						((VorsorgendeBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(74220)),
						pruefer.calculateIndex()));
		// Nein-Button einfügen
		JButton no = new DatenschutzAblehnungAktion((LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(74052),
				this, pruefer).toButton();
		getButtonPane().add(no, FlowLayout.CENTER, 1);
	}

	/**
	 * @return {@link Boolean#TRUE} - wenn Ok gedrückt wird, ist alles gut.
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
	 */
	@Override
	protected DatenschutzZustimmung baueRueckgabewert() {
		return pruefer.getRueckgabewert();
	}
	// // protected Boolean baueRueckgabewert() {
	// return Boolean.TRUE;
	// }
	// leseComponents(tabbedPane).

	/**
	 * Die Methode initialisiert die allgemeinen {@link JComponent}s für den
	 * Inhaltsbereich des Dialogs und wird vom Konstruktor
	 * {@link HinzufuegenDialog#HinzufuegenDialog(JFrame, String)} selbsttätig
	 * aufgerufen.
	 * 
	 * Vorsicht! In dieser Implementierung werden nur eine {@link JTabbedPane} und
	 * eine {@link JPanel} gebaut; die {@link JPanel} (contentPanel) wird aber der
	 * {@link JTabbedPane} noch nicht hinzugefügt. Das erledigt
	 * {@link #baueTabbedPane(int)}. Grund: Reihenfolge des Aufrufs, denn der
	 * Konstruktor der Oberklasse ruft bereits die hiesige Methode auf; erst dann
	 * kann der Konstruktor der hiesigen Klasse den Index übergeben.
	 */
	@Override
	protected void baueContentPane() {
		GridBagLayout gbl_contentPanel = new GridBagLayout();

		tabbedPane = new JTabbedPane();
		getContentPane().add(tabbedPane, BorderLayout.CENTER);

		contentPanel.setBorder(BORDER);
		contentPanel.setLayout(gbl_contentPanel);

	}

	@Override
	protected void fuelleContentPane() {
		baueTextPane(htmlfile);
		// .applyTo
		lblFrage = (JLabel) beschrifter.beschrifte(new JLabel(), (NameContainer) beschrifter
				.changeTo(((Vorsorgend<?>) NameContainerSammlung.BESCHRIFTUNGEN.get(74220)), pruefer.calculateIndex()));
		lblFrage.setHorizontalAlignment(SwingConstants.RIGHT);
		contentPanel.add(lblFrage,
				GitterBeutelBeschraenkungen.getInstance(0, 1, 3, 1, GridBagConstraints.HORIZONTAL, true));
	}

	/**
	 * Die Methode krönt je nach index den ersten oder zweiten Reiter der
	 * {@link JTabbedPane} auf aktiv und bestückt nur diesen.
	 * 
	 * @param level entweder {@link DatenschutzZustimmung#OPTION_DSGVO_EMAIL_BASIS}
	 *              oder {@link DatenschutzZustimmung#OPTION_DSGVO_EMAIL_ANHANG}
	 * 
	 * @see javax.swing.JTabbedPane#setSelectedIndex(int)
	 */
	private void baueTabbedPane(int level) {
		int activeTab;
		if (DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG == level
				&& pruefer.getRueckgabewert().emailBasisZugestimmt) {
			// Zweites Tab nur, wenn erstem Level schon zugestimmt
			activeTab = 1;
			TabbedPaneFactory.intoTabbedPane(tabbedPane, new JPanel(),
					(Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(74100));
			TabbedPaneFactory.intoTabbedPane(tabbedPane, contentPanel,
					(Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(74200));
			setHtmlFile(DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG);
		} else {
			// Erstes Tab
			activeTab = 0;
			TabbedPaneFactory.intoTabbedPane(tabbedPane, contentPanel,
					(Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(74100));
			TabbedPaneFactory.intoTabbedPane(tabbedPane, new JPanel(),
					(Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(74200));
			setHtmlFile(DatenschutzZustimmung.OPTION_DSGVO_EMAIL_BASIS);
		}
		activateTabs(activeTab);
		tabbedPane.setSelectedIndex(activeTab);
	}
	// setHtmlFile(level);

	/**
	 * Die Methode wählt die passende HTML-Datei aus.
	 * 
	 * @param level entweder {@link DatenschutzZustimmung#OPTION_DSGVO_EMAIL_BASIS}
	 *              oder {@link DatenschutzZustimmung#OPTION_DSGVO_EMAIL_ANHANG}
	 */
	private void setHtmlFile(int level) {
		if (DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG == level) {
			this.htmlfile = RESOURCES_DSGVO_ANHANG;
		} else {
			this.htmlfile = RESOURCES_DSGVO_BASIS;
		}
	}

	private void activateTabs(int activeTab) {
		for (int i = 0; i < tabbedPane.getTabCount(); i++) {
			if (activeTab == i)
				tabbedPane.setEnabledAt(i, true);
			else
				tabbedPane.setEnabledAt(i, false);
		}
	}

}
//private static final String TITLE = "Datenschutzerklärung";
//TITLE
// AbstractAction ok = super.getOkAction();
// ok.putValue(Action.NAME, "Ja, ich stimme zu!");
// ok.putValue(Action.MNEMONIC_KEY, KeyEvent.VK_J);
// ok.putValue(Action.SHORT_DESCRIPTION, "Der Datenschutzerklärung zustimmen");
// tabbedPane.addTab("Einfacher E-Mail-Versand", null);
// tabbedPane.addTab("E-Mail-Versand mit Zusätzen", null);
// tabbedPane.setComponentAt(activeTab, contentPanel);

/*
 * @return gibt {@link HinzufuegenDialog#okButton} als {@link AbstractButton}
 * zurück.
 */
// public AbstractButton getButton() {
// return super.getOkButton();
// }